/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.tree.TreePath;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.JNiceButton;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableRowTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.ui.ProfilPayeModel;
import org.openconcerto.erp.model.FichePayeModel;
import org.openconcerto.erp.model.RubriquePayeTree;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;

public class ProfilPayeSQLElement
extends ComptaSQLConfElement {
    public ProfilPayeSQLElement(DBRoot root) {
        super(root.getTable("PROFIL_PAYE"), "un profil de paye", "profils de paye");
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction("Actualiser les salari\u00e9s li\u00e8s au profil"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues rowSel = IListe.get(e).getSelectedRow();
                SQLSelect selAllIDProfilElt = new SQLSelect();
                SQLTable tableProfilElt = ProfilPayeSQLElement.this.getTable().getTable("PROFIL_PAYE_ELEMENT");
                selAllIDProfilElt.addSelectStar(tableProfilElt);
                selAllIDProfilElt.setWhere(new Where((FieldRef)tableProfilElt.getField("ID_PROFIL_PAYE"), "=", ((SQLRowAccessor)rowSel).getID()));
                selAllIDProfilElt.addFieldOrder(tableProfilElt.getField("POSITION"));
                List<SQLRow> profilElt = SQLRowListRSH.execute(selAllIDProfilElt);
                SQLSelect selSal = new SQLSelect();
                selSal.addSelectStar(ProfilPayeSQLElement.this.getTable().getDBRoot().findTable("SALARIE"));
                List<SQLRow> rowSal = SQLRowListRSH.execute(selSal);
                int updateSalCount = 0;
                for (SQLRow sqlRow : rowSal) {
                    SQLRow rowFichePaye = sqlRow.getForeign("ID_FICHE_PAYE");
                    if (rowFichePaye.getObject("ID_PROFIL_PAYE") == null || rowFichePaye.getForeignID("ID_PROFIL_PAYE") != ((SQLRowAccessor)rowSel).getID()) continue;
                    ProfilPayeSQLElement.this.loadFromProfil(rowFichePaye, profilElt);
                    ++updateSalCount;
                }
                JOptionPane.showMessageDialog(null, String.valueOf(updateSalCount) + " mis \u00e0 jour!", "Actualisation bulletin", 1);
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, "NOM");
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private ProfilPayeModel model;
            private JTextField nom;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
                labelNom.setHorizontalAlignment(4);
                this.add((Component)labelNom, c);
                this.nom = new JTextField();
                ++c.gridx;
                this.add((Component)this.nom, c);
                final RubriquePayeTree treeRubrique = new RubriquePayeTree();
                JPanel panelLeft = new JPanel();
                panelLeft.setLayout(new GridBagLayout());
                c.gridx = 0;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.fill = 1;
                c.gridheight = 0;
                panelLeft.add((Component)new JScrollPane(treeRubrique), c);
                JPanel panelRight = new JPanel();
                panelRight.setLayout(new GridBagLayout());
                c.fill = 2;
                c.gridheight = 1;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.gridx = 0;
                c.gridy = 0;
                JLabelBold labelContenu = new JLabelBold("Contenu du profil");
                panelRight.add((Component)labelContenu, c);
                c.fill = 0;
                JNiceButton boutonUp = new JNiceButton(IListFrame.class.getResource("fleche_haut.png"));
                ++c.gridx;
                panelRight.add((Component)boutonUp, c);
                JNiceButton boutonDown = new JNiceButton(IListFrame.class.getResource("fleche_bas.png"));
                ++c.gridx;
                panelRight.add((Component)boutonDown, c);
                JNiceButton boutonSuppr = new JNiceButton(ConfSQLElement.class.getResource("delete.png"));
                ++c.gridx;
                panelRight.add((Component)boutonSuppr, c);
                c.fill = 2;
                this.model = new ProfilPayeModel(this.getSelectedID());
                final JTable tableProfil = new JTable(this.model);
                tableProfil.setDefaultRenderer(String.class, AlternateTableCellRenderer.createDefault());
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 0;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                panelRight.add((Component)new JScrollPane(tableProfil), c);
                c.gridx = 0;
                c.gridy = 1;
                c.gridwidth = 0;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)new JSplitPane(1, panelLeft, panelRight), c);
                treeRubrique.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mE) {
                        if (mE.getClickCount() == 2 && mE.getButton() == 1) {
                            TreePath path = treeRubrique.getClosestPathForLocation(mE.getPoint().x, mE.getPoint().y);
                            Object obj = path.getLastPathComponent();
                            if (obj == null) {
                                return;
                            }
                            if (obj instanceof VariableRowTreeNode) {
                                model.addRowAt(((VariableRowTreeNode)obj).getRow(), tableProfil.getSelectedRow());
                            } else {
                                return;
                            }
                        }
                    }
                });
                boutonUp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int selectRow = model.upRow(tableProfil.getSelectedRow());
                        if (selectRow > 0) {
                            tableProfil.setRowSelectionInterval(selectRow, selectRow);
                        }
                    }
                });
                boutonDown.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int selectRow = model.downRow(tableProfil.getSelectedRow());
                        if (selectRow > 0) {
                            tableProfil.setRowSelectionInterval(selectRow, selectRow);
                        }
                    }
                });
                boutonSuppr.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        model.removeRow(tableProfil.getSelectedRow());
                    }
                });
                this.addRequiredSQLObject(this.nom, "NOM");
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                this.model.updateFields(id);
                return id;
            }

            @Override
            public void update() {
                this.model.updateFields(this.getSelectedID());
                super.update();
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                if (r != null) {
                    this.model.selectID(r.getID());
                }
            }
        };
    }

    @Override
    protected String createCode() {
        return "humanresources.payroll.template";
    }

    public void loadFromProfil(SQLRow rowFichePaye, List<SQLRow> rowProfilElt) {
        System.err.println("Load from profil");
        SQLTable ficheEltTable = rowFichePaye.getTable().getTable("FICHE_PAYE_ELEMENT");
        UpdateBuilder archiveElt = new UpdateBuilder(ficheEltTable);
        archiveElt.setObject("ARCHIVE", (Object)1);
        archiveElt.setWhere(new Where((FieldRef)ficheEltTable.getField("ID_FICHE_PAYE"), "=", rowFichePaye.getID()));
        this.getTable().getDBSystemRoot().getDataSource().execute(archiveElt.asString());
        SQLRowValues rowValsFiche = rowFichePaye.createEmptyUpdateRow();
        int position = 1;
        for (SQLRow profilLigne : rowProfilElt) {
            SQLRowValues rowVals = new SQLRowValues(ficheEltTable);
            String source = profilLigne.getString("SOURCE");
            int idSource = profilLigne.getInt("IDSOURCE");
            rowVals.put("NOM", this.getTable().getTable(source).getRow(idSource).getString("NOM"));
            rowVals.put("SOURCE", source);
            rowVals.put("IDSOURCE", idSource);
            rowVals.put("POSITION", position);
            rowVals.put("ID_FICHE_PAYE", (Object)rowValsFiche);
            ++position;
        }
        try {
            rowValsFiche.commit();
            FichePayeModel model = new FichePayeModel(rowValsFiche.getID());
            model.loadAllElements();
        }
        catch (SQLException e) {
            ExceptionHandler.handle("Erreur lors de la mise \u00e0 jour du bulletin!", e);
        }
    }
}

