/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.SheetInterface;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.cc.ITransformer;

public class JournauxSheet
extends SheetInterface {
    protected static int debutFill;
    protected static int endFill;
    private static final SQLTable tableEcriture;
    protected static final SQLTable tableJournal;
    private static final SQLTable tableMvt;
    protected static final SQLTable tableCompte;
    public static final int MODEALL = 1;
    public static final int MODELETTREE = 2;
    public static final int MODENONLETTREE = 3;
    private final DateFormat dateFormat = DateFormat.getDateInstance(2);
    private final DateFormat dateFormatEcr = DateFormat.getDateInstance(3);
    protected Date dateDu;
    protected Date dateAu;
    protected int[] idS;
    protected int lettrage;
    private String compteDeb;
    private String compteEnd;
    public static String TEMPLATE_ID;
    public static String TEMPLATE_PROPERTY_NAME;

    static {
        tableEcriture = base.getTable("ECRITURE");
        tableJournal = base.getTable("JOURNAL");
        tableMvt = base.getTable("MOUVEMENT");
        tableCompte = base.getTable("COMPTE_PCE");
        TEMPLATE_ID = "JournauxAncien";
        TEMPLATE_PROPERTY_NAME = "LocationJournaux";
        JournauxSheet.setSize(7, 68);
    }

    public static void setSize(int debut, int fin) {
        debutFill = debut;
        endFill = fin;
    }

    @Override
    public String getTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    protected String getYear() {
        return "";
    }

    public JournauxSheet(int[] id, Date du, Date au, int lettrage, String compteDeb, String compteEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(au);
        this.printer = PrinterNXProps.getInstance().getStringProperty("JournauxPrinter");
        this.modele = String.valueOf(this.getTemplateId()) + ".ods";
        this.dateAu = au;
        this.dateDu = du;
        this.idS = id;
        this.lettrage = lettrage;
        this.nbRowsPerPage = 71;
        this.compteDeb = compteDeb;
        this.compteEnd = compteEnd;
        System.err.println("Init ids with values ");
        int i = 0;
        while (i < id.length) {
            System.err.println(id[i]);
            ++i;
        }
        this.createMap();
    }

    protected void makeEntete(int row, String nomJournal) {
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        this.mCell.put("A" + row, rowSociete.getObject("NOM"));
        this.mCell.put("F" + row, "Edition du " + this.dateFormat.format(new Date()));
        System.err.println("MAKE ENTETE");
    }

    protected void makeBasPage(int row, String nomJournal) {
        this.mCell.put("A" + row, "Journal : " + nomJournal);
        this.mCell.put("E" + row, "P\u00e9riode du " + this.dateFormatEcr.format(this.dateDu) + " au " + this.dateFormatEcr.format(this.dateAu));
    }

    @Override
    protected void createMap() {
        this.mapReplace = new HashMap();
        this.mCell = new HashMap();
        this.mapStyleRow = new HashMap();
        SQLRowValues vals = new SQLRowValues(tableEcriture);
        vals.put("ID_JOURNAL", null);
        vals.put("ID_COMPTE_PCE", null);
        vals.put("COMPTE_NUMERO", null);
        vals.put("COMPTE_NOM", null);
        vals.put("JOURNAL_CODE", null);
        vals.put("JOURNAL_NOM", null);
        vals.putRowValues("ID_MOUVEMENT").put("NUMERO", null);
        vals.put("CREDIT", null);
        vals.put("DEBIT", null);
        vals.put("DATE", null);
        vals.put("NOM", null);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(vals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                Where w = new Where((FieldRef)tableEcriture.getField("DATE"), JournauxSheet.this.dateDu, (Object)JournauxSheet.this.dateAu);
                Where w2 = null;
                int i = 0;
                while (i < JournauxSheet.this.idS.length) {
                    w2 = w2 == null ? new Where((FieldRef)tableEcriture.getField("ID_JOURNAL"), "=", JournauxSheet.this.idS[i]) : w2.or(new Where((FieldRef)tableEcriture.getField("ID_JOURNAL"), "=", JournauxSheet.this.idS[i]));
                    ++i;
                }
                if (JournauxSheet.this.lettrage == 2) {
                    Object o = null;
                    w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "<>", (Object)o));
                    w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "!=", (Object)""));
                } else if (JournauxSheet.this.lettrage == 3) {
                    Object o = null;
                    Where w3 = new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)o);
                    w = w.and(w3.or(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)"")));
                }
                w = JournauxSheet.this.compteDeb.equals(JournauxSheet.this.compteEnd) ? w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), "=", (Object)JournauxSheet.this.compteDeb)) : w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), (Object)JournauxSheet.this.compteDeb, (Object)JournauxSheet.this.compteEnd));
                if (!UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
                    w = w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
                }
                sel.setWhere(w.and(w2));
                sel.addFieldOrder(sel.getAlias(tableEcriture.getField("ID_JOURNAL")));
                sel.addFieldOrder(sel.getAlias(tableEcriture.getField("DATE")));
                sel.addFieldOrder(sel.getAlias(tableMvt.getField("NUMERO")));
                return sel;
            }
        });
        List<SQLRowValues> list = fetcher.fetch();
        int posLine = 1;
        int firstLine = 1;
        System.err.println("START CREATE JOURNAUX, NB ecritures  " + list.size());
        this.nbPage = 0;
        long totalDebit = 0L;
        long totalCredit = 0L;
        int prevIdMvt = 0;
        SQLRowValues rowFirstEcr = null;
        String firstJournal = null;
        int i = 0;
        while (i < list.size()) {
            rowFirstEcr = list.get(i);
            if (firstJournal == null || !firstJournal.equalsIgnoreCase(rowFirstEcr.getString("JOURNAL_NOM"))) {
                totalDebit = 0L;
                totalCredit = 0L;
            }
            firstJournal = rowFirstEcr.getString("JOURNAL_NOM");
            System.err.println("START NEW PAGE --> Journal : " + firstJournal + "; POS : " + posLine);
            this.makeEntete(posLine, firstJournal);
            posLine += debutFill - 1;
            int j = 0;
            while (j < endFill - debutFill + 1 && i < list.size()) {
                SQLRowValues rowEcr = list.get(i);
                String journal = rowEcr.getString("JOURNAL_NOM");
                if (!journal.equalsIgnoreCase(firstJournal)) break;
                SQLRowAccessor rowMvt = rowEcr.getForeign("ID_MOUVEMENT");
                if (prevIdMvt != rowMvt.getID()) {
                    prevIdMvt = rowMvt.getID();
                    this.mapStyleRow.put(new Integer(posLine), "Titre 1");
                } else {
                    this.mapStyleRow.put(new Integer(posLine), "Normal");
                }
                this.mCell.put("A" + posLine, this.dateFormatEcr.format(rowEcr.getDate("DATE").getTime()));
                this.mCell.put("B" + posLine, rowEcr.getString("COMPTE_NUMERO"));
                this.mCell.put("C" + posLine, rowMvt.getObject("NUMERO"));
                this.mCell.put("D" + posLine, rowEcr.getObject("NOM"));
                long deb = (Long)rowEcr.getObject("DEBIT");
                long cred = (Long)rowEcr.getObject("CREDIT");
                long solde = deb - cred;
                totalCredit += cred;
                totalDebit += deb;
                this.mCell.put("E" + posLine, deb == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(deb, false)));
                this.mCell.put("F" + posLine, cred == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(cred, false)));
                this.mCell.put("G" + posLine, solde == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(solde, false)));
                ++i;
                ++posLine;
                ++j;
            }
            posLine = firstLine + endFill;
            this.mCell.put("E" + posLine, totalDebit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalDebit, false)));
            this.mCell.put("F" + posLine, totalCredit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalCredit, false)));
            this.mCell.put("G" + posLine, totalDebit - totalCredit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalDebit - totalCredit, false)));
            this.makeBasPage(posLine += 2, firstJournal);
            firstLine = ++posLine;
            ++this.nbPage;
        }
        if (this.nbPage > 0) {
            --this.nbPage;
        }
    }
}

