/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;

public abstract class TransfertBaseSQLComponent
extends BaseSQLComponent {
    protected SQLRowAccessor selectedRow;
    private List<SQLRowValues> sourceRows;

    public TransfertBaseSQLComponent(SQLElement element) {
        super(element);
    }

    public void loadItem(AbstractArticleItemTable table, SQLElement elt, int id, SQLElement itemsElt) {
        this.loadItem(table, elt, id, itemsElt, true);
    }

    public void loadItem(AbstractArticleItemTable table, SQLElement elt, int id, SQLElement itemsElt, boolean clear) {
        Collection myListItem = elt.getTable().getRow(id).getReferentRows(itemsElt.getTable());
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(itemsElt.getTable(), table.getSQLElement().getTable());
            if (clear) {
                table.getModel().clearRows();
            }
            for (SQLRow rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt);
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                table.getModel().addRow(createRowValuesFrom, false);
                int rowIndex = table.getModel().getRowCount() - 1;
                table.getModel().fireTableModelModified(rowIndex);
            }
        } else if (clear) {
            table.getModel().clearRows();
            table.getModel().addNewRowAt(0);
        }
        table.getModel().fireTableDataChanged();
        table.repaint();
    }

    public void importFrom(List<SQLRowValues> rows) {
        this.sourceRows = rows;
        if (rows.size() > 0) {
            SQLInjector injector = SQLInjector.getInjector(rows.get(0).getTable(), this.getTable());
            SQLRowValues rValues = injector.createRowValuesFrom(rows);
            this.select(rValues);
        } else {
            this.select(null);
        }
    }

    @Override
    public int insert(SQLRow order) {
        int insertedId = super.insert(order);
        if (insertedId != -1 && this.sourceRows != null && !this.sourceRows.isEmpty()) {
            SQLInjector injector = SQLInjector.getInjector(this.sourceRows.get(0).getTable(), this.getTable());
            try {
                injector.commitTransfert(this.sourceRows, insertedId);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Unable to insert transfert", e);
            }
        }
        return insertedId;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r == null) {
            super.select(null);
            return;
        }
        super.select(r);
        RowValuesTable table = this.getRowValuesTable();
        if (table != null) {
            table.clear();
            table.insertFrom(r);
        }
        this.refreshAfterSelect(r);
    }

    protected abstract void refreshAfterSelect(SQLRowAccessor var1);

    protected RowValuesTable getRowValuesTable() {
        return null;
    }

    public static EditFrame openTransfertFrame(List<SQLRowValues> sourceRows, String destTableName) {
        return TransfertBaseSQLComponent.openTransfertFrame(sourceRows, destTableName, null);
    }

    public static EditFrame openTransfertFrame(List<SQLRowValues> sourceRows, String destTableName, String compID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement(destTableName);
        EditFrame editFrame = compID == null || compID.trim().length() == 0 ? new EditFrame(elt) : new EditFrame(elt.createComponent(compID), EditPanel.EditMode.CREATION);
        editFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        SQLComponent sqlComponent = editFrame.getSQLComponent();
        if (sqlComponent instanceof TransfertBaseSQLComponent) {
            TransfertBaseSQLComponent comp = (TransfertBaseSQLComponent)sqlComponent;
            if (!sourceRows.isEmpty()) {
                final ArrayList<Number> ids = new ArrayList<Number>(sourceRows.size());
                for (SQLRowValues sqlRowValues : sourceRows) {
                    ids.add(sqlRowValues.getIDNumber());
                }
                final SQLRowValues row = new SQLRowValues(sourceRows.get(0).getTable());
                for (SQLField rk : row.getTable().getDBSystemRoot().getGraph().getReferentKeys(row.getTable())) {
                    Collection referentRows = row.getReferentRows(rk);
                    if (referentRows.size() <= 1) continue;
                    Iterator iter = new ArrayList(referentRows).iterator();
                    iter.next();
                    while (iter.hasNext()) {
                        SQLRowValues ref = (SQLRowValues)iter.next();
                        ref.remove(rk.getName());
                    }
                }
                for (SQLRowValues r : row.getGraph().getItems()) {
                    HashSet<String> fields = new HashSet<String>(r.getTable().getFieldsName());
                    fields.removeAll(r.getFields());
                    r.putNulls(fields, false);
                }
                SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(row);
                fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        input.setWhere(new Where(row.getTable().getKey(), ids));
                        return input;
                    }
                });
                List<SQLRowValues> result = fetcher.fetch();
                comp.importFrom(result);
                FrameUtil.show(editFrame);
            }
            return editFrame;
        }
        throw new IllegalArgumentException("Table " + destTableName + " SQLComponent is not a TransfertBaseSQLComponent");
    }

    public static boolean isAlreadyAllTransfert(List<SQLRowValues> selectedRows, final SQLTable from, final SQLTable to, String fieldTotalFrom, String fieldTotalTo) {
        final SQLTable tableTransfert = from.getTable("TR_" + from.getName());
        SQLRowValues rowVals = new SQLRowValues(tableTransfert);
        rowVals.put("ID_" + from.getName(), (Object)new SQLRowValues(from).put("NUMERO", null).put(fieldTotalFrom, null));
        rowVals.putRowValues("ID_" + to.getName()).put("NUMERO", null).put(fieldTotalTo, null);
        rowVals.put("ID", null);
        final ArrayList<Integer> lID = new ArrayList<Integer>();
        for (SQLRowValues sqlRowValues : selectedRows) {
            lID.add(sqlRowValues.getID());
        }
        SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(rowVals);
        fetch.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where(tableTransfert.getField("ID_" + from.getName()), lID);
                w = w.and(new Where((FieldRef)tableTransfert.getField("ID_" + to.getName()), "IS NOT", (Object)null));
                input.setWhere(w);
                return input;
            }
        });
        List<SQLRowValues> rows = fetch.fetch();
        if (rows != null && rows.size() > 0) {
            String numero = "";
            long totalBR = 0L;
            long totalFact = 0L;
            HashSet<String> idsAdded = new HashSet<String>();
            for (SQLRowValues sqlRow : rows) {
                String toKey;
                SQLRowAccessor foreignBR = sqlRow.getForeign("ID_" + from.getName());
                SQLRowAccessor foreignFact = sqlRow.getForeign("ID_" + to.getName());
                numero = String.valueOf(numero) + foreignBR.getString("NUMERO") + " ,";
                String fromKey = String.valueOf(from.getName()) + "-" + foreignBR.getID();
                if (!idsAdded.contains(fromKey)) {
                    totalBR += foreignBR.getLong(fieldTotalFrom);
                    idsAdded.add(fromKey);
                }
                if (idsAdded.contains(toKey = String.valueOf(to.getName()) + "-" + foreignFact.getID())) continue;
                totalFact += foreignFact.getLong(fieldTotalTo);
                idsAdded.add(toKey);
            }
            numero = numero.substring(0, numero.length() - 2);
            return totalBR <= totalFact;
        }
        return Boolean.FALSE;
    }
}

