/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DFontTextDrawer;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DFontTextDrawer;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class PdfBoxGraphics2DFontTextDrawerDefaultFonts
extends PdfBoxGraphics2DFontTextDrawer {
    private static final Logger LOG = Logger.getLogger("de.rototor.pdfbox.graphics2d");

    @Override
    protected PDFont mapFont(Font font, IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        PDFont pdFont = PdfBoxGraphics2DFontTextDrawerDefaultFonts.mapDefaultFonts(font);
        if (pdFont != null) {
            return pdFont;
        }
        pdFont = super.mapFont(font, env);
        if (pdFont != null) {
            return pdFont;
        }
        PDFont f = PdfBoxGraphics2DFontTextDrawerDefaultFonts.chooseMatchingHelvetica(font);
        LOG.warning("font : " + font.getFontName() + " is missing, using fallback font :" + f.getName());
        return f;
    }

    public static PDFont mapDefaultFonts(Font font) {
        if (PdfBoxGraphics2DFontTextDrawerDefaultFonts.fontNameEqualsAnyOf(font, "SansSerif", "Dialog", "DialogInput", "Helvetica")) {
            return PdfBoxGraphics2DFontTextDrawerDefaultFonts.chooseMatchingHelvetica(font);
        }
        if (PdfBoxGraphics2DFontTextDrawerDefaultFonts.fontNameEqualsAnyOf(font, "Monospaced", "courier", "courier new")) {
            return PdfBoxGraphics2DFontTextDrawerDefaultFonts.chooseMatchingCourier(font);
        }
        if (PdfBoxGraphics2DFontTextDrawerDefaultFonts.fontNameEqualsAnyOf(font, "Serif", "Times", "Times New Roman", "Times Roman")) {
            return PdfBoxGraphics2DFontTextDrawerDefaultFonts.chooseMatchingTimes(font);
        }
        if (PdfBoxGraphics2DFontTextDrawerDefaultFonts.fontNameEqualsAnyOf(font, "Symbol")) {
            return PDType1Font.SYMBOL;
        }
        if (PdfBoxGraphics2DFontTextDrawerDefaultFonts.fontNameEqualsAnyOf(font, "ZapfDingbats", "Dingbats")) {
            return PDType1Font.ZAPF_DINGBATS;
        }
        return null;
    }

    private static boolean fontNameEqualsAnyOf(Font font, String ... names) {
        String name = font.getName();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String fontName = stringArray[n2];
            if (fontName.equalsIgnoreCase(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static PDFont chooseMatchingTimes(Font font) {
        if ((font.getStyle() & 3) == 3) {
            return PDType1Font.TIMES_BOLD_ITALIC;
        }
        if ((font.getStyle() & 2) == 2) {
            return PDType1Font.TIMES_ITALIC;
        }
        if ((font.getStyle() & 1) == 1) {
            return PDType1Font.TIMES_BOLD;
        }
        return PDType1Font.TIMES_ROMAN;
    }

    public static PDFont chooseMatchingCourier(Font font) {
        if ((font.getStyle() & 3) == 3) {
            return PDType1Font.COURIER_BOLD_OBLIQUE;
        }
        if ((font.getStyle() & 2) == 2) {
            return PDType1Font.COURIER_OBLIQUE;
        }
        if ((font.getStyle() & 1) == 1) {
            return PDType1Font.COURIER_BOLD;
        }
        return PDType1Font.COURIER;
    }

    public static PDFont chooseMatchingHelvetica(Font font) {
        if ((font.getStyle() & 3) == 3) {
            return PDType1Font.HELVETICA_BOLD_OBLIQUE;
        }
        if ((font.getStyle() & 2) == 2) {
            return PDType1Font.HELVETICA_OBLIQUE;
        }
        if ((font.getStyle() & 1) == 1) {
            return PDType1Font.HELVETICA_BOLD;
        }
        return PDType1Font.HELVETICA;
    }
}

