/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class Tuple2<A, B> {
    private static final Tuple2<Object, Object> NULL = new Tuple2<Object, Object>(null, null);
    private final A a;
    private final B b;

    public static final <A, B> Tuple2<A, B> nullInstance() {
        return NULL;
    }

    public static final <A, B> Tuple2<A, B> create(A a, B b) {
        return new Tuple2<A, B>(a, b);
    }

    public Tuple2(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public final A get0() {
        return this.a;
    }

    public final B get1() {
        return this.b;
    }

    public List<? extends Object> asList() {
        return Arrays.asList(this.get0(), this.get1());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tuple2) {
            Tuple2 o = (Tuple2)obj;
            return this.asList().equals(o.asList());
        }
        return false;
    }

    public int hashCode() {
        return this.asList().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.asList();
    }

    public static class List2<A>
    extends Tuple2<A, A> {
        public static <A> List2<A> create(Collection<? extends A> col) {
            Object a2;
            Object a1;
            if (col.size() != 2) {
                throw new IllegalArgumentException("Wrong size : " + col.size());
            }
            if (col instanceof RandomAccess && col instanceof List) {
                List l = (List)col;
                a1 = l.get(0);
                a2 = l.get(1);
            } else {
                Iterator<A> iter = col.iterator();
                a1 = iter.next();
                a2 = iter.next();
                assert (!iter.hasNext());
            }
            return new List2<A>(a1, a2);
        }

        public List2(A a1, A a2) {
            super(a1, a2);
        }

        @Override
        public final List<A> asList() {
            return Arrays.asList(this.get0(), this.get1());
        }
    }
}

