/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.group.modifier;

import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.GroupModifier;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.modifier.ItemGroupModifier;

public class MoveToGroupModifier
extends ItemGroupModifier {
    private Group dest;

    public MoveToGroupModifier(String itemId, Group dest) {
        super(itemId);
        if (dest == null) {
            throw new IllegalArgumentException("null dest");
        }
        this.dest = dest;
    }

    @Override
    public void applyOn(Group g) {
        Item i = g.getDescFromID(this.getItemId());
        i.getParent().remove(this.getItemId());
        this.dest.add(i);
    }

    @Override
    public boolean canBeAppliedOn(Group g) {
        return g.contains(this.dest.getId()) && g.contains(this.getItemId());
    }

    @Override
    public boolean isCompatibleWith(GroupModifier g) {
        MoveToGroupModifier gr;
        return !(g instanceof MoveToGroupModifier) || !(gr = (MoveToGroupModifier)g).getItemId().equals(this.getItemId()) || !gr.dest.getId().equals(this.dest.getId());
    }
}

