/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.MenuContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModulePreferencePanelDesc;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;

public abstract class AbstractModule {
    private final ModuleFactory factory;
    private File localDir;

    public AbstractModule(ModuleFactory f) throws IOException {
        this.factory = f;
        this.localDir = null;
    }

    public final ModuleFactory getFactory() {
        return this.factory;
    }

    public final String getName() {
        return this.getFactory().getName();
    }

    public final String getDescription() {
        return this.getFactory().getDescription();
    }

    public final int getVersion() {
        return this.getFactory().getMajorVersion();
    }

    final void setLocalDirectory(File f) {
        if (f == null) {
            throw new NullPointerException("Null dir");
        }
        if (this.localDir != null) {
            throw new IllegalStateException("Already set to " + this.localDir);
        }
        this.localDir = f;
    }

    protected final File getLocalDirectory() {
        return this.localDir;
    }

    protected void install(DBContext ctxt) throws SQLException, IOException {
    }

    protected void setupElements(SQLElementDirectory dir) {
    }

    protected void setupMenu(MenuContext menuContext) {
    }

    protected void setupComponents(ComponentsContext ctxt) {
    }

    protected abstract void start();

    public List<ModulePreferencePanelDesc> getPrefDescriptors(DBRoot root) {
        return Collections.emptyList();
    }

    public final Map<Boolean, List<ModulePreferencePanelDesc>> getPrefDescriptorsByLocation(DBRoot root) {
        HashMap<Boolean, List<ModulePreferencePanelDesc>> res = new HashMap<Boolean, List<ModulePreferencePanelDesc>>();
        for (ModulePreferencePanelDesc desc : this.getPrefDescriptors(root)) {
            List<ModulePreferencePanelDesc> l;
            Boolean key = desc.isLocal();
            if (!res.containsKey(key)) {
                l = new ArrayList();
                res.put(key, l);
            } else {
                l = (List)res.get(key);
            }
            l.add(desc);
        }
        return res;
    }

    protected abstract void stop();

    protected void uninstall(DBRoot root) {
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " created from " + this.getFactory();
    }
}

