/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.protocol.Helper;

public class SimpleURLClassLoader
extends SecureClassLoader {
    private final List<URL> urls;

    public static final URL toURL(File f) {
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Couldn't transform file to URL " + f, e);
        }
    }

    public static final String toResourceName(String bundleName, String suffix) {
        StringBuilder sb = new StringBuilder(bundleName.length() + 1 + suffix.length());
        sb.append(bundleName.replace('.', '/')).append('.').append(suffix);
        return sb.toString();
    }

    public static final String toClassFile(String bundleName) {
        return SimpleURLClassLoader.toResourceName(bundleName, "class");
    }

    public SimpleURLClassLoader(URLCollector urls) {
        this.urls = urls.copyToUnmodifiableList();
    }

    public SimpleURLClassLoader(URLCollector urls, ClassLoader parent) {
        super(parent);
        this.urls = urls.copyToUnmodifiableList();
    }

    protected URL createURL(URL url, String spec) throws MalformedURLException {
        return new URL(url, spec);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (URL baseURL : this.urls) {
            try {
                URL url = this.createURL(baseURL, SimpleURLClassLoader.toClassFile(name));
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream ins = url.openConnection().getInputStream();){
                    byte[] bytes = StreamUtils.read(ins);
                    return this.defineClass(name, bytes, 0, bytes.length, new CodeSource(url, null));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException connectExn) {
                Log.get().log(Level.FINE, connectExn, () -> "Couldn't connect to " + baseURL + " for " + name);
            }
        }
        return super.findClass(name);
    }

    @Override
    protected URL findResource(String name) {
        for (URL baseURL : this.urls) {
            try {
                URL url = this.createURL(baseURL, name);
                boolean exists = false;
                if (url.getProtocol().equals("file")) {
                    exists = new File(url.toURI()).exists();
                } else {
                    Object hconn;
                    URLConnection uc = url.openConnection();
                    if (uc instanceof HttpURLConnection) {
                        hconn = (HttpURLConnection)uc;
                        ((HttpURLConnection)hconn).setRequestMethod("HEAD");
                        exists = ((HttpURLConnection)hconn).getResponseCode() < 400;
                    } else {
                        uc.setUseCaches(false);
                        try {
                            hconn = null;
                            Object var8_11 = null;
                            try (InputStream ins = uc.getInputStream();){
                                exists = true;
                            }
                            catch (Throwable throwable) {
                                if (hconn == null) {
                                    hconn = throwable;
                                } else if (hconn != throwable) {
                                    ((Throwable)hconn).addSuppressed(throwable);
                                }
                                throw hconn;
                            }
                        }
                        catch (IOException e) {
                            exists = false;
                        }
                    }
                }
                if (!exists) continue;
                return url;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.findResource(name);
    }

    public static class URLCollector {
        private final List<URL> urls = new ArrayList<URL>();

        public final List<URL> copyToUnmodifiableList() {
            return Collections.unmodifiableList(new ArrayList<URL>(this.urls));
        }

        public final URLCollector add(URL url) {
            this.urls.add(url);
            return this;
        }

        public final URLCollector addDirectory(File dir) {
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("Not a directory : " + dir);
            }
            return this.add(SimpleURLClassLoader.toURL(dir));
        }

        public final URLCollector addJar(File jar) {
            if (!jar.isFile()) {
                throw new IllegalArgumentException("Not a file : " + jar);
            }
            return this.addJar(SimpleURLClassLoader.toURL(jar));
        }

        public final URLCollector addJar(URL u) {
            return this.add(Helper.intoJar(u));
        }

        public final URLCollector addJars(Iterable<URL> jars) {
            for (URL jar : jars) {
                this.addJar(jar);
            }
            return this;
        }
    }
}

