/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.model;

import java.util.AbstractList;
import java.util.List;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.model.DefaultIMutableListModel;

public final class NewSelection
extends Enum<NewSelection> {
    public static final /* enum */ NewSelection NO = new NewSelection();
    public static final /* enum */ NewSelection NONE = new NewSelection();
    public static final /* enum */ NewSelection DIFFERENT_INDEX = new NewSelection();
    public static final /* enum */ NewSelection SAME_INDEX = new NewSelection();
    private static final /* synthetic */ NewSelection[] ENUM$VALUES;

    static {
        ENUM$VALUES = new NewSelection[]{NO, NONE, DIFFERENT_INDEX, SAME_INDEX};
    }

    public final <T> T getNewSelection(DefaultIMutableListModel<T> model, int selectedIndex, int from, int to, int replacementCount) {
        return this.getNewSelection(model, selectedIndex, true, from, to, null, replacementCount);
    }

    public final <T> T getNewSelection(DefaultIMutableListModel<T> model, int selectedIndex, int from, int to, List<T> replacement) {
        return this.getNewSelection(model, selectedIndex, false, from, to, replacement, replacement.size());
    }

    private final <T> T getNewSelection(DefaultIMutableListModel<T> model, int selectedIndex, boolean listAlreadyChanged, int from, int to, List<T> replacement, int replacementCount) {
        Object newSel;
        if (this == NO) {
            throw new UnsupportedOperationException();
        }
        ReplaceView changedList = new ReplaceView(model.getList(), listAlreadyChanged, from, to, replacement, replacementCount);
        int newSize = changedList.getListView().size();
        if (this == NONE || newSize == 0) {
            return null;
        }
        if (this == SAME_INDEX) {
            int newIndex = selectedIndex < newSize ? selectedIndex : newSize - 1;
            newSel = changedList.getListView().get(newIndex);
        } else {
            assert (this == DIFFERENT_INDEX);
            newSel = from > 0 ? changedList.getOutsideReplacement(-1) : changedList.getOutsideReplacement(0, true);
        }
        return newSel;
    }

    public static NewSelection[] values() {
        NewSelection[] newSelectionArray = ENUM$VALUES;
        int n = newSelectionArray.length;
        NewSelection[] newSelectionArray2 = new NewSelection[n];
        System.arraycopy(ENUM$VALUES, 0, newSelectionArray2, 0, n);
        return newSelectionArray2;
    }

    public static NewSelection valueOf(String string) {
        return Enum.valueOf(NewSelection.class, string);
    }

    public static final class ReplaceView<T> {
        private final int to;
        private final int from;
        private final int replacementCount;
        private final int addedCount;
        private final List<T> list;

        public ReplaceView(final List<T> l, boolean replaced, final int from, int to, final List<T> replacement, int replacementCount) {
            if (!replaced && replacement == null) {
                throw new IllegalArgumentException("Missing replacement");
            }
            this.to = to;
            this.from = from;
            assert (replacement == null || replacementCount == replacement.size());
            this.replacementCount = replacementCount;
            this.addedCount = this.getReplacementCount() - this.getRemovedCount();
            this.list = replaced ? l : new AbstractList<T>(){
                private final int size;
                {
                    this.size = list.size() + replaceView.getAddedCount();
                }

                @Override
                public T get(int index) {
                    if (index < from) {
                        return l.get(index);
                    }
                    if (index < from + this.getReplacementCount()) {
                        return replacement.get(index - from);
                    }
                    return l.get(index - this.getAddedCount());
                }

                @Override
                public int size() {
                    return this.size;
                }
            };
        }

        public final int getRemovedCount() {
            return this.to - this.from + 1;
        }

        public final int getReplacementCount() {
            return this.replacementCount;
        }

        public final int getAddedCount() {
            return this.addedCount;
        }

        public final List<T> getListView() {
            return this.list;
        }

        public T getOutsideReplacement(int offset) {
            return this.getOutsideReplacement(offset, false);
        }

        public T getOutsideReplacement(int offset, boolean lenient) {
            int index = this.from + (offset < 0 ? 0 : this.getReplacementCount()) + offset;
            if (lenient) {
                return CollectionUtils.getNoExn(this.getListView(), index);
            }
            return this.getListView().get(index);
        }
    }
}

