/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.openconcerto.utils.io.Printer;

public class NewLineWriter
extends FilterWriter
implements Printer {
    private final String lineSep;

    public NewLineWriter(Writer out) {
        this(out, System.getProperty("line.separator"));
    }

    public NewLineWriter(Writer out, String lineSep) {
        super(out);
        this.lineSep = lineSep;
    }

    public final String getLineSeparator() {
        return this.lineSep;
    }

    public final void writeln(String s) throws IOException {
        this.write(s);
        this.newLine();
    }

    public final void newLine() throws IOException {
        this.write(this.lineSep);
    }

    @Override
    public final void print(String s) throws IOException {
        this.write(s);
    }

    @Override
    public final void println(String s) throws IOException {
        this.writeln(s);
    }

    @Override
    public final void println() throws IOException {
        this.newLine();
    }
}

