/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openconcerto.utils.checks.ValidChangeSupport;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public class ValidObjectCombiner
implements ValidObject {
    private final List<ValidObject> objects;
    private final ValidChangeSupport supp;

    public static final ValidObjectCombiner create(ValidObject delegate, Object ... objects) {
        ArrayList<ValidObject> validObjects = new ArrayList<ValidObject>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ValidObject) {
                validObjects.add((ValidObject)o);
            }
            ++n2;
        }
        return new ValidObjectCombiner(delegate, validObjects);
    }

    public ValidObjectCombiner(ValidObject delegate, ValidObject ... objects) {
        this(delegate, Arrays.asList(objects));
    }

    public ValidObjectCombiner(ValidObject delegate, List<ValidObject> objects) {
        this.objects = objects;
        this.supp = new ValidChangeSupport(delegate);
        for (ValidObject o : this.objects) {
            o.addValidListener(new ValidListener(){

                @Override
                public void validChange(ValidObject src, ValidState newValue) {
                    ValidObjectCombiner.this.validChanged();
                }
            });
        }
    }

    protected final void validChanged() {
        this.supp.fireValidChange(this.getValidState());
    }

    @Override
    public ValidState getValidState() {
        ValidState res = ValidState.getTrueInstance();
        for (ValidObject o : this.objects) {
            res = res.and(o.getValidState(), " ; ");
        }
        return res;
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.supp.removeValidListener(l);
    }
}

