/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openconcerto.utils.CollectionMap2;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.UnmodifiableCollectionMap;

public class SetMap<K, V>
extends CollectionMap2<K, Set<V>, V>
implements CollectionMap2Itf.SetMapItf<K, V> {
    private static SetMap EMPTY = new SetMap(Collections.emptyMap(), CollectionMap2.Mode.NULL_FORBIDDEN){

        @Override
        public SetMap clone() {
            return this;
        }
    };

    public static <K, V> CollectionMap2Itf.SetMapItf<K, V> unmodifiableMap(CollectionMap2Itf.SetMapItf<K, V> map) {
        if (map.isEmpty()) {
            return SetMap.empty();
        }
        return new Unmodifiable(map);
    }

    public static <K, V> SetMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> SetMap<K, V> singleton(K key, V ... values) {
        return SetMap.singleton(key, Arrays.asList(values));
    }

    public static <K, V> SetMap<K, V> singleton(K key, Collection<? extends V> values) {
        return SetMap.singleton(key, new HashSet<V>(values), false);
    }

    private static <K, V> SetMap<K, V> singleton(K key, Set<V> values, boolean immutable) {
        Set<V> coll = immutable ? values : Collections.unmodifiableSet(values);
        return new SetMap<K, V>((Map)Collections.singletonMap(key, coll), DEFAULT_MODE){

            @Override
            public SetMap<K, V> clone() {
                return this;
            }
        };
    }

    public static <K, V> SetMap<K, V> singleton(K key, V value) {
        return SetMap.singleton(key, Collections.singleton(value), true);
    }

    public static <K, V> SetMap<K, V> decorate(Map<K, Set<V>> m) {
        return new SetMap<K, V>(m, DEFAULT_MODE);
    }

    public SetMap() {
    }

    public SetMap(int initialCapacity, CollectionMap2.Mode mode, boolean emptyCollSameAsNoColl) {
        super(initialCapacity, mode, (Boolean)emptyCollSameAsNoColl);
    }

    public SetMap(int initialCapacity) {
        super(initialCapacity);
    }

    public SetMap(CollectionMap2.Mode mode, boolean emptyCollSameAsNoColl) {
        super(mode, emptyCollSameAsNoColl);
    }

    public SetMap(CollectionMap2.Mode mode) {
        super(mode);
    }

    public SetMap(Map<K, Set<V>> delegate, CollectionMap2.Mode mode) {
        super(delegate, mode);
    }

    public SetMap(Map<K, Set<V>> delegate, CollectionMap2.Mode mode, Boolean emptyCollSameAsNoColl) {
        super(delegate, mode, emptyCollSameAsNoColl);
    }

    public SetMap(CollectionMap2<K, Set<V>, ? extends V> m) {
        super(m);
    }

    public SetMap(Map<? extends K, ? extends Collection<? extends V>> m) {
        super(m);
    }

    @Override
    public Set<V> createCollection(Collection<? extends V> v) {
        return new HashSet<V>(v);
    }

    @Override
    public SetMap<K, V> clone() {
        return (SetMap)super.clone();
    }

    private static class Unmodifiable<K, V>
    extends UnmodifiableCollectionMap<K, Set<V>, V>
    implements CollectionMap2Itf.SetMapItf<K, V> {
        Unmodifiable(CollectionMap2Itf<K, Set<V>, V> delegate) {
            super(delegate, new UnmodifiableCollectionMap.UnmodifiableMap<K, Set<V>>((Map)delegate){

                @Override
                protected Set<V> nonNullToUnmodifiable(Set<V> coll) {
                    return Collections.unmodifiableSet(coll);
                }
            });
        }
    }
}

