/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

public final class Matrix<T> {
    private final List<List<T>> rows;
    private final T defaultItem;

    public Matrix() {
        this(8);
    }

    public Matrix(int initialHeight) {
        this(initialHeight, null);
    }

    public Matrix(int initialCapacity, T defaultItem) {
        this.rows = new ArrayList<List<T>>(initialCapacity);
        this.defaultItem = defaultItem;
    }

    public Matrix(Matrix<? extends T> o) {
        this(o.rows.size(), o.defaultItem);
        for (List<T> l : o.rows) {
            this.rows.add(new ArrayList<T>(l));
        }
    }

    private final List<List<T>> createEmptyRows(int count) {
        ArrayList<List<T>> res = new ArrayList<List<T>>(count);
        int i = 0;
        while (i < count) {
            res.add(new ArrayList());
            ++i;
        }
        return res;
    }

    public final int getHeight() {
        return this.rows.size();
    }

    public final int getWidth(int y) {
        if (y >= this.getHeight()) {
            throw new IndexOutOfBoundsException(String.valueOf(y) + " >=" + this.getHeight());
        }
        return this.rows.get(y).size();
    }

    public final void put(int x, int y, T item) {
        List<T> row;
        if (this.rows.size() <= y) {
            this.rows.addAll(this.createEmptyRows(y - this.rows.size() + 1));
        }
        if ((row = this.rows.get(y)).size() <= x) {
            row.addAll(Collections.nCopies(x - row.size() + 1, this.defaultItem));
        }
        row.set(x, item);
    }

    public final T get(int x, int y) {
        if (this.rows.size() <= y) {
            return null;
        }
        List<T> row = this.rows.get(y);
        if (row.size() <= x) {
            return null;
        }
        return row.get(x);
    }

    public final void iterate(IClosure<Tuple2<Point, T>> c) {
        ListIterator<List<T>> iter1 = this.rows.listIterator();
        while (iter1.hasNext()) {
            List<T> l = iter1.next();
            ListIterator<T> iter2 = l.listIterator();
            while (iter2.hasNext()) {
                T item = iter2.next();
                c.executeChecked(Tuple2.create(new Point(iter2.previousIndex(), iter1.previousIndex()), item));
            }
        }
    }

    public final void iteratePoints(final IClosure<Point> c) {
        this.iterate(new IClosure<Tuple2<Point, T>>(){

            @Override
            public void executeChecked(Tuple2<Point, T> input) {
                c.executeChecked(input.get0());
            }
        });
    }

    public final String print(int cellLength, ITransformer<T, ?> transf) {
        String spaces;
        if (cellLength < 0) {
            spaces = null;
        } else {
            char[] array = new char[cellLength];
            Arrays.fill(array, ' ');
            spaces = new String(array);
        }
        StringBuilder sb = new StringBuilder();
        for (List<T> row : this.rows) {
            for (T item : row) {
                String s;
                String string = item == null ? "" : (s = (transf == null ? item : transf.transformChecked(item)).toString());
                if (spaces == null) {
                    sb.append(s);
                    sb.append('\t');
                    continue;
                }
                if (s.length() < cellLength) {
                    sb.append(s);
                    sb.append(spaces.substring(s.length()));
                } else if (s.length() == cellLength) {
                    sb.append(s.substring(0, cellLength));
                } else {
                    int middle = cellLength / 2;
                    sb.append(s.substring(0, middle));
                    sb.append('\u2026');
                    sb.append(s.substring(s.length() - (cellLength - middle - 1), s.length()));
                }
                sb.append(' ');
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Matrix) {
            return this.rows.equals(((Matrix)obj).rows);
        }
        return false;
    }

    public int hashCode() {
        return this.rows.hashCode();
    }

    public String toString() {
        return this.print(20, null);
    }
}

