/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import org.openconcerto.utils.Unzip;
import org.openconcerto.utils.Zip;

public class EncryptedClassLoader
extends URLClassLoader {
    public static final String USAGE = "usage: EncryptedClassLoader (-run <encrypt dir> <app_main_class> <app_main_args...> | -encrypt <class 1> <class 2> ...)";
    public static final boolean TRACE = false;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new IllegalArgumentException(USAGE);
        }
        if ("-run".equals(args[0]) && args.length >= 3) {
            EncryptedClassLoader appLoader = new EncryptedClassLoader(EncryptedClassLoader.class.getClassLoader(), new File(args[1]));
            Thread.currentThread().setContextClassLoader(appLoader);
            Class<?> app = appLoader.loadClass(args[2]);
            Method appmain = app.getMethod("main", String[].class);
            String[] appargs = new String[args.length - 3];
            System.arraycopy(args, 3, appargs, 0, appargs.length);
            appmain.invoke(null, new Object[]{appargs});
        } else if ("-encrypt".equals(args[0]) && args.length >= 2) {
            int f = 1;
            while (f < args.length) {
                String item = args[f];
                File srcFile = new File(item);
                EncryptedClassLoader.encrypt(new FileInputStream(srcFile), srcFile);
                ++f;
            }
        } else if ("-encryptJar".equals(args[0]) && args.length >= 3) {
            File srcJar = new File(args[1]);
            File destJar = new File(args[2]);
            HashSet<String> excluded = new HashSet<String>(args.length - 3);
            int i = 3;
            while (i < args.length) {
                String excl = args[i];
                excluded.add(excl);
                ++i;
            }
            Zip z = new Zip(destJar);
            Unzip unz = new Unzip(srcJar);
            Enumeration<? extends ZipEntry> iter = unz.entries();
            while (iter.hasMoreElements()) {
                ZipEntry entry = iter.nextElement();
                InputStream in = entry.getName().endsWith(".class") && !excluded.contains(entry.getName()) ? new ByteArrayInputStream(EncryptedClassLoader.encrypt(unz.getInputStream(entry))) : unz.getInputStream(entry);
                z.zip(entry.getName(), in);
            }
            unz.close();
            z.close();
        } else {
            throw new IllegalArgumentException(USAGE);
        }
    }

    private static byte[] encrypt(InputStream in) throws IOException {
        byte[] classBytes;
        try {
            classBytes = EncryptedClassLoader.readFully(in);
            EncryptedClassLoader.crypt(classBytes);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ignore) {
                    ignore.printStackTrace();
                }
            }
        }
        return classBytes;
    }

    private static void encrypt(InputStream in, File outFile) throws IOException {
        byte[] classBytes = EncryptedClassLoader.encrypt(in);
        FileOutputStream out = new FileOutputStream(outFile);
        try {
            ((OutputStream)out).write(classBytes);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception ignore) {
                    ignore.printStackTrace();
                }
            }
        }
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        c = this.findLoadedClass(name);
        if (c == null) {
            Class<?> parentsVersion = null;
            try {
                parentsVersion = this.getParent().loadClass(name);
                if (parentsVersion.getClassLoader() != this.getParent()) {
                    c = parentsVersion;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassFormatError classFormatError) {
                // empty catch block
            }
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException ignore) {
                    c = parentsVersion;
                }
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String classResource = String.valueOf(name.replace('.', '/')) + ".class";
        URL classURL = this.getResource(classResource);
        if (classURL == null) {
            throw new ClassNotFoundException(name);
        }
        InputStream in = null;
        try {
            in = classURL.openStream();
            byte[] classBytes = EncryptedClassLoader.readFully(in);
            EncryptedClassLoader.decrypt(classBytes);
            Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length);
            return clazz;
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(name);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private EncryptedClassLoader(ClassLoader parent, File classpath) throws MalformedURLException {
        super(new URL[]{classpath.toURL()}, parent);
        if (parent == null) {
            throw new IllegalArgumentException("EncryptedClassLoader requires a non-null delegation parent");
        }
    }

    private static void crypt(byte[] data) {
        int i = 8;
        while (i < data.length) {
            int n = i++;
            data[n] = (byte)(data[n] ^ 0x5A);
        }
    }

    private static void decrypt(byte[] data) {
        EncryptedClassLoader.crypt(data);
    }

    private static byte[] readFully(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream buf1 = new ByteArrayOutputStream();
        byte[] buf2 = new byte[8192];
        while ((read = in.read(buf2)) > 0) {
            buf1.write(buf2, 0, read);
        }
        return buf1.toByteArray();
    }
}

