/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class RoundedBorder
implements Border {
    private final int cornerlWidth;
    private final int cornerlHeight;
    private final Color topColor;
    private final Color bottomColor;

    public RoundedBorder(int w, int h, Color topColor, Color bottomColor) {
        this.cornerlWidth = w;
        this.cornerlHeight = h;
        this.topColor = topColor;
        this.bottomColor = bottomColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.cornerlHeight, this.cornerlWidth, this.cornerlHeight, this.cornerlWidth);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.topColor);
        g.drawLine(x, y + --height - this.cornerlHeight, x, y + this.cornerlHeight);
        g.drawArc(x, y, 2 * this.cornerlWidth, 2 * this.cornerlHeight, 180, -90);
        g.drawLine(x + this.cornerlWidth, y, x + --width - this.cornerlWidth, y);
        g.drawArc(x + width - 2 * this.cornerlWidth, y, 2 * this.cornerlWidth, 2 * this.cornerlHeight, 90, -90);
        g.setColor(this.bottomColor);
        g.drawLine(x + width, y + this.cornerlHeight, x + width, y + height - this.cornerlHeight);
        g.drawArc(x + width - 2 * this.cornerlWidth, y + height - 2 * this.cornerlHeight, 2 * this.cornerlWidth, 2 * this.cornerlHeight, 0, -90);
        g.drawLine(x + this.cornerlWidth, y + height, x + width - this.cornerlWidth, y + height);
        g.drawArc(x, y + height - 2 * this.cornerlHeight, 2 * this.cornerlWidth, 2 * this.cornerlHeight, -90, -90);
    }
}

