/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class InfiniteProgressPanel
extends JPanel
implements MouseListener {
    protected Area[] ticker = null;
    protected Thread animation = null;
    protected boolean started = false;
    protected int alphaLevel = 0;
    protected int rampDelay = 300;
    protected float shield = 0.7f;
    protected JPanel panel;
    protected int barsCount = 14;
    protected float fps = 15.0f;
    protected RenderingHints hints = null;

    public InfiniteProgressPanel(JPanel panel) {
        this(panel, 14);
    }

    public InfiniteProgressPanel(JPanel panel, int barsCount) {
        this(panel, barsCount, 0.7f);
    }

    public InfiniteProgressPanel(JPanel panel, int barsCount, float shield) {
        this(panel, barsCount, shield, 5.0f);
    }

    public InfiniteProgressPanel(JPanel panel, int barsCount, float shield, float fps) {
        this(panel, barsCount, shield, fps, 500);
    }

    public InfiniteProgressPanel(JPanel panel, int barsCount, float shield, float fps, int rampDelay) {
        this.panel = panel;
        this.rampDelay = rampDelay >= 0 ? rampDelay : 0;
        this.shield = shield >= 0.0f ? shield : 0.0f;
        this.fps = fps > 0.0f ? fps : 15.0f;
        this.barsCount = barsCount > 0 ? barsCount : 14;
        this.setOpaque(false);
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 1;
        c.gridy = 1;
        JPanel p1 = new JPanel();
        p1.setOpaque(false);
        this.add((Component)p1, c);
        ++c.gridx;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panel.setBorder(BorderFactory.createBevelBorder(0));
        this.add((Component)panel, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        ++c.gridx;
        ++c.gridy;
        JPanel p2 = new JPanel();
        p2.setOpaque(false);
        this.add((Component)p2, c);
    }

    public void start() {
        this.addMouseListener(this);
        this.setVisible(true);
        this.animation = new Thread(new Animator(true));
        this.animation.start();
    }

    public void stop() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
            this.animation = new Thread(new Animator(false));
            this.animation.start();
        }
    }

    public void interrupt() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
            this.removeMouseListener(this);
            this.setVisible(false);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.started) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHints(this.hints);
            g2.setColor(new Color(255, 255, 255, (int)((float)this.alphaLevel * this.shield)));
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    protected class Animator
    implements Runnable {
        private boolean rampUp = true;

        protected Animator(boolean rampUp) {
            this.rampUp = rampUp;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            if (InfiniteProgressPanel.this.rampDelay == 0) {
                InfiniteProgressPanel.this.alphaLevel = this.rampUp ? 255 : 0;
            }
            InfiniteProgressPanel.this.started = true;
            boolean inRamp = this.rampUp;
            while (!Thread.interrupted() && inRamp) {
                block8: {
                    block7: {
                        if (!this.rampUp) break block7;
                        if (InfiniteProgressPanel.this.alphaLevel >= 255) break block8;
                        InfiniteProgressPanel.this.alphaLevel = (int)(255L * (System.currentTimeMillis() - start) / (long)InfiniteProgressPanel.this.rampDelay);
                        if (InfiniteProgressPanel.this.alphaLevel < 255) break block8;
                        InfiniteProgressPanel.this.alphaLevel = 255;
                        inRamp = false;
                        break block8;
                    }
                    if (InfiniteProgressPanel.this.alphaLevel > 0) {
                        InfiniteProgressPanel.this.alphaLevel = (int)(255L - 255L * (System.currentTimeMillis() - start) / (long)InfiniteProgressPanel.this.rampDelay);
                        if (InfiniteProgressPanel.this.alphaLevel <= 0) {
                            InfiniteProgressPanel.this.alphaLevel = 0;
                            break;
                        }
                    }
                }
                InfiniteProgressPanel.this.repaint();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {
                    break;
                }
                Thread.yield();
            }
            if (!this.rampUp) {
                InfiniteProgressPanel.this.started = false;
                InfiniteProgressPanel.this.repaint();
                InfiniteProgressPanel.this.setVisible(false);
                InfiniteProgressPanel.this.removeMouseListener(InfiniteProgressPanel.this);
            }
        }
    }
}

