/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.utils.CollectionUtils;

public class SQLTableModelColumnPath
extends SQLTableModelColumn {
    private final FieldPath p;
    private final SQLElementDirectory dir;
    private boolean editable;

    public static final RowItemDesc getDescFor(SQLField field, SQLElementDirectory dir) {
        RowItemDesc res;
        if (dir == null && Configuration.getInstance() != null) {
            dir = Configuration.getInstance().getDirectory();
        }
        RowItemDesc rowItemDesc = res = dir == null ? SQLFieldTranslator.NULL_DESC : dir.getTranslator().getDescFor(field.getTable(), field.getName());
        if (res.equals(SQLFieldTranslator.NULL_DESC)) {
            return SQLFieldTranslator.getDefaultDesc(field);
        }
        return res;
    }

    public SQLTableModelColumnPath(Path p, String fieldName, String name) {
        this(new FieldPath(p, fieldName), name, null);
    }

    public SQLTableModelColumnPath(SQLField f) {
        this(new FieldPath(f));
    }

    public SQLTableModelColumnPath(FieldPath fp) {
        this(fp, null, null);
    }

    public SQLTableModelColumnPath(FieldPath fp, String name, SQLElementDirectory dir) {
        super(name == null ? SQLTableModelColumnPath.getDescFor(fp.getField(), dir).getTitleLabel() : name);
        this.p = fp;
        this.dir = dir;
        this.editable = true;
    }

    @Override
    public String getIdentifier() {
        return this.p.toString();
    }

    @Override
    public String getToolTip() {
        ArrayList<String> humanPath = new ArrayList<String>(this.p.getPath().length());
        for (SQLField f : this.p.getPath().getSingleFields()) {
            humanPath.add(SQLTableModelColumnPath.getDescFor(f, this.dir).getLabel());
        }
        humanPath.add(SQLTableModelColumnPath.getDescFor(this.p.getField(), this.dir).getLabel());
        return CollectionUtils.join(humanPath, " \u25ba ");
    }

    public SQLField getField() {
        return this.p.getField();
    }

    @Override
    public Set<SQLField> getFields() {
        return Collections.singleton(this.getField());
    }

    @Override
    public Set<FieldPath> getPaths() {
        return Collections.singleton(this.p);
    }

    @Override
    protected Class<?> getValueClass_() {
        return this.getField().getType().getJavaType();
    }

    @Override
    public boolean isEditable() {
        return this.editable && this.p.getPath().length() == 0;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    protected Object show_(SQLRowAccessor r) {
        return this.p.getObject(r.asRowValues());
    }

    @Override
    protected void put_(ListSQLLine l, Object value) {
        if (value == null && this.getField().isNullable() != Boolean.TRUE) {
            value = SQLRowValues.SQL_DEFAULT;
        }
        SQLRowValues ourVals = l.getRow().followPath(this.p.getPath());
        SQLRowValues vals = new SQLRowValues(this.p.getPath().getLast()).put(this.p.getFieldName(), value);
        if (ourVals != null && ourVals.hasID()) {
            vals.setID(ourVals.getIDNumber());
        }
        vals.getGraph().freeze();
        try {
            l.getSrc().commit(l, this.p.getPath(), vals);
        }
        catch (SQLException e) {
            throw new IllegalStateException("unable to set " + this + " to " + value, e);
        }
    }
}

