/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.AbstractFileTransfertHandler;
import org.openconcerto.sql.view.DropManager;
import org.openconcerto.sql.view.FileDropHandler;

public class FileTransfertHandler
extends TransferHandler {
    private final SQLTable tableName;

    public FileTransfertHandler(SQLTable table) {
        this.tableName = table;
    }

    @Override
    public boolean importData(final JComponent c, Transferable t) {
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        final ArrayList<File> list = new ArrayList<File>();
        try {
            if (this.hasFileFlavor(t.getTransferDataFlavors())) {
                list.addAll((List)t.getTransferData(DataFlavor.javaFileListFlavor));
            } else if (this.hasURIListFlavor(t.getTransferDataFlavors())) {
                list.addAll(AbstractFileTransfertHandler.textURIListToFileList((String)t.getTransferData(AbstractFileTransfertHandler.getURIListFlavor())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Thread thread = new Thread("FileTransfertHandler " + this.tableName){

                @Override
                public void run() {
                    List<FileDropHandler> handlers = FileTransfertHandler.this.getHandlers();
                    block0: for (File realFile : list) {
                        Log.get().info("Searching handler for file:" + realFile.getAbsolutePath());
                        for (FileDropHandler handler : handlers) {
                            if (!handler.canHandle(realFile)) continue;
                            Log.get().config("Importing file:" + realFile.getAbsolutePath() + " with " + handler);
                            handler.handle(realFile, c);
                            continue block0;
                        }
                    }
                }
            };
            thread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list.size() > 0;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        if (this.getHandlers().isEmpty()) {
            Log.get().config("No drop handler for table " + this.tableName);
            return false;
        }
        if (this.hasFileFlavor(flavors) || this.hasURIListFlavor(flavors)) {
            return true;
        }
        Log.get().config("No files or URL found in dropped object");
        return false;
    }

    private boolean hasFileFlavor(DataFlavor[] flavors) {
        int i = 0;
        while (i < flavors.length) {
            if (DataFlavor.javaFileListFlavor.equals(flavors[i]) || "application/x-java-remote-object".equals(flavors[i].getMimeType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasURIListFlavor(DataFlavor[] flavors) {
        int i = 0;
        while (i < flavors.length) {
            if (AbstractFileTransfertHandler.getURIListFlavor().equals(flavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected List<FileDropHandler> getHandlers() {
        return DropManager.getInstance().getHandlerForTable(this.tableName);
    }
}

