/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.StringUtils;

public class RowBackedCodeGenerator {
    public static String getCode(SQLTable table, String className, String packageName) {
        StringBuilder result = new StringBuilder();
        if (table == null) {
            return "";
        }
        if (packageName != null && packageName.length() > 0) {
            result.append("package ");
            result.append(packageName);
            result.append(";\n\n");
        }
        result.append("import org.openconcerto.sql.element.RowBacked;\n");
        result.append("import org.openconcerto.sql.model.SQLRowAccessor;\n\n");
        result.append("import java.sql.Timestamp;\n");
        result.append("import java.sql.Blob;\n");
        result.append("import java.math.BigDecimal;\n\n");
        result.append("public class " + className + " extends RowBacked {\n\n");
        result.append("   public " + className + "(SQLRowAccessor r) {\n");
        result.append("        super(r);\n");
        result.append("   }\n\n");
        ArrayList<SQLField> f = new ArrayList<SQLField>(table.getFields());
        Collections.sort(f, new Comparator<SQLField>(){

            @Override
            public int compare(SQLField o1, SQLField o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (SQLField field : f) {
            String type = field.getType().getJavaType().getSimpleName();
            String methodName = "get" + RowBackedCodeGenerator.getJavaName(field.getName());
            if (methodName.equals("getTable")) {
                methodName = "getFieldTable";
            }
            result.append("   public " + type + " " + methodName + "() {\n");
            result.append("        return (" + type + ") this.get(\"" + field.getName() + "\");\n");
            result.append("   }\n\n");
        }
        result.append("}\n");
        return result.toString();
    }

    public static String getJavaName(String s) {
        s = s.replace('+', '_');
        s = s.replace(' ', '_');
        String result = "";
        String[] ss = s.split("_");
        int i = 0;
        while (i < ss.length) {
            result = String.valueOf(result) + StringUtils.firstUpThenLow(ss[i]);
            ++i;
        }
        return result;
    }
}

