/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.preferences;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.replication.MemoryRep;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.Value;

@ThreadSafe
public class SQLPreferences
extends AbstractPreferences {
    private static final boolean GET_NODE_JAVA_RECURSION = false;
    private static final String PREF_NODE_TABLENAME = "PREF_NODE";
    private static final String PREF_VALUE_TABLENAME = "PREF_VALUE";
    private static final Map<DBRoot, SQLPreferences> memCachedbyRoots = new IdentityHashMap<DBRoot, SQLPreferences>(8);
    private final Object nodeLock = new Object();
    private final SQLTable prefRT;
    private final SQLTable prefWT;
    private final SQLTable nodeRT;
    private final SQLTable nodeWT;
    private final MemoryRep rep;
    private final List<SQLPreferences> ancestors;
    @GuardedBy(value="lock")
    private Map<String, String> values;
    @GuardedBy(value="lock")
    private final Map<String, String> changedValues;
    @GuardedBy(value="lock")
    private final Set<String> removedKeys;
    @GuardedBy(value="nodeLock")
    private SQLRow node;

    private static final String getJoinName(int i) {
        return "j" + i;
    }

    private static SQLCreateTable[] getCreateTables(DBRoot root) throws SQLException {
        SQLCreateTable createNodeT = new SQLCreateTable(root, PREF_NODE_TABLENAME);
        createNodeT.setPlain(true);
        createNodeT.addColumn("ID", createNodeT.getSyntax().getPrimaryIDDefinition());
        createNodeT.addColumn("ID_PARENT", String.valueOf(createNodeT.getSyntax().getIDType()) + " NULL");
        createNodeT.addVarCharColumn("NAME", 80);
        createNodeT.addForeignConstraint("ID_PARENT", new SQLName(createNodeT.getName()), "ID");
        createNodeT.addUniqueConstraint("uniqNamePerParent", Arrays.asList("ID_PARENT", "NAME"));
        SQLCreateTable createValueT = new SQLCreateTable(root, PREF_VALUE_TABLENAME);
        createValueT.setPlain(true);
        createValueT.addColumn("ID_NODE", String.valueOf(createValueT.getSyntax().getIDType()) + " NOT NULL");
        createValueT.addVarCharColumn("NAME", 80);
        createValueT.addVarCharColumn("VALUE", 8192, true);
        createValueT.setPrimaryKey("ID_NODE", "NAME");
        createValueT.addForeignConstraint("ID_NODE", new SQLName(createNodeT.getName()), "ID");
        return new SQLCreateTable[]{createNodeT, createValueT};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLTable getPrefTable(DBRoot root) throws SQLException {
        Object object = root.getDBSystemRoot().getTreeMutex();
        synchronized (object) {
            if (!root.contains(PREF_VALUE_TABLENAME)) {
                root.createTables(SQLPreferences.getCreateTables(root));
            }
            return root.getTable(PREF_VALUE_TABLENAME);
        }
    }

    public static SQLPreferences startMemCached(DBRoot root) throws SQLException {
        return SQLPreferences.startMemCached(root, 8L, TimeUnit.MINUTES, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLPreferences startMemCached(DBRoot root, long period, TimeUnit unit, boolean returnExisting) throws SQLException {
        Map<DBRoot, SQLPreferences> map = memCachedbyRoots;
        synchronized (map) {
            if (!memCachedbyRoots.containsKey(root)) {
                MemoryRep memoryRep = new MemoryRep(root.getDBSystemRoot(), TablesMap.createFromTables(root.getName(), Arrays.asList(PREF_NODE_TABLENAME, PREF_VALUE_TABLENAME)));
                try {
                    memoryRep.start(period, unit);
                }
                catch (InterruptedException e) {
                    throw new RTInterruptedException(e);
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
                SQLPreferences res = new SQLPreferences(memoryRep);
                memCachedbyRoots.put(root, res);
                return res;
            }
            if (!returnExisting) {
                throw new IllegalStateException("Preferences already created for " + root);
            }
            return memCachedbyRoots.get(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLPreferences getMemCached(DBRoot root) {
        SQLPreferences res;
        Map<DBRoot, SQLPreferences> map = memCachedbyRoots;
        synchronized (map) {
            res = memCachedbyRoots.get(root);
        }
        if (res == null) {
            throw new IllegalStateException("No preferences for " + root);
        }
        return res;
    }

    public SQLPreferences(DBRoot db) {
        this(null, db.getTable(PREF_VALUE_TABLENAME), db.getTable(PREF_VALUE_TABLENAME), db.getTable(PREF_NODE_TABLENAME), db.getTable(PREF_NODE_TABLENAME));
    }

    private SQLPreferences(MemoryRep rep) {
        this(rep, rep.getSlaveTable(PREF_VALUE_TABLENAME), rep.getMasterTable(PREF_VALUE_TABLENAME), rep.getSlaveTable(PREF_NODE_TABLENAME), rep.getMasterTable(PREF_NODE_TABLENAME));
    }

    private SQLPreferences(MemoryRep rep, SQLTable prefRT, SQLTable prefWT, SQLTable nodeRT, SQLTable nodeWT) {
        this(null, "", rep, prefRT, prefWT, nodeRT, nodeWT);
    }

    private SQLPreferences(SQLPreferences parent, String name) {
        this(parent, name, parent.rep, parent.prefRT, parent.prefWT, parent.nodeRT, parent.nodeWT);
    }

    private SQLPreferences(SQLPreferences parent, String name, MemoryRep rep, SQLTable prefRT, SQLTable prefWT, SQLTable nodeRT, SQLTable nodeWT) {
        super(parent, name);
        this.prefRT = prefRT;
        this.prefWT = prefWT;
        this.nodeRT = nodeRT;
        this.nodeWT = nodeWT;
        this.rep = rep;
        this.ancestors = Collections.unmodifiableList(this.findAncestors());
        this.values = null;
        this.changedValues = new HashMap<String, String>();
        this.removedKeys = new HashSet<String>();
        this.resetNode();
    }

    private final SQLTable getNodeRT() {
        return this.nodeRT;
    }

    private final SQLTable getPrefRT() {
        return this.prefRT;
    }

    private final SQLTable getNodeWT() {
        return this.nodeWT;
    }

    private final SQLTable getPrefWT() {
        return this.prefWT;
    }

    private final SQLDataSource getReadDS() {
        return this.getPrefRT().getDBSystemRoot().getDataSource();
    }

    private final SQLDataSource getWriteDS() {
        return this.getPrefWT().getDBSystemRoot().getDataSource();
    }

    private Object execute(String sel, ResultSetHandler rsh) {
        if (this.rep != null) {
            try {
                this.rep.waitOnLastManualFuture();
            }
            catch (InterruptedException e) {
                throw new RTInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.getReadDS().execute(sel, new IResultSetHandler(rsh, false));
    }

    private final void replicate() {
        if (this.rep != null) {
            this.rep.submitReplicate();
        }
    }

    private final boolean isRoot() {
        return this.absolutePath().equals("/");
    }

    private final LinkedList<SQLPreferences> findAncestors() {
        SQLPreferences p;
        assert (!Thread.holdsLock(this.lock)) : "Deadlock possible since we access parent()";
        LinkedList<SQLPreferences> res = new LinkedList<SQLPreferences>();
        res.add(this);
        SQLPreferences current = this;
        while ((p = (SQLPreferences)current.parent()) != null) {
            res.addFirst(p);
            current = p;
        }
        return res;
    }

    private final List<SQLPreferences> getAncestors() {
        if (this.isRemoved()) {
            throw new IllegalStateException("Node has been removed.");
        }
        return this.ancestors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resetNode() {
        Object object = this.nodeLock;
        synchronized (object) {
            this.node = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setNode(SQLRow r) {
        Object object = this.nodeLock;
        synchronized (object) {
            this.node = r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SQLRow getNode() {
        Object object = this.nodeLock;
        synchronized (object) {
            if (this.node != null) {
                return this.node;
            }
            try {
                Value<SQLRow> res = this.getNodeFromRoot();
                if (res.hasValue()) {
                    this.setNode(res.getValue());
                    return res.getValue();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        List<SQLPreferences> ancestors = this.getAncestors();
        SQLRow currentNode = null;
        for (SQLPreferences ancestor : ancestors) {
            currentNode = ancestor.getNode(currentNode);
        }
        return currentNode;
    }

    private final Value<SQLRow> getNodeFromRoot() throws SQLException {
        int[] vers;
        StringTokenizer tokenizer = new StringTokenizer(this.absolutePath(), "/");
        ArrayList<String> path = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            path.add(tokenizer.nextToken());
        }
        SQLBase base = this.getNodeRT().getSchema().getBase();
        if (path.size() > 2 && base.getServer().getSQLSystem() == SQLSystem.POSTGRESQL && ((vers = base.getVersion())[0] >= 9 || vers[0] == 8 && vers[1] >= 4)) {
            return Value.getSome(this.getNodeCTE(path, base));
        }
        return Value.getSome(this.getNodeJoins(path));
    }

    private SQLRow getNodeJoins(List<String> path) {
        int size = path.size();
        SQLTable nodeT = this.getNodeRT();
        SQLSelect sel = new SQLSelect();
        AliasedTable rootT = new AliasedTable(nodeT, "root");
        sel.addFrom(rootT);
        String lastAlias = rootT.getAlias();
        int i = 0;
        while (i < size) {
            SQLSelectJoin join = sel.addBackwardJoin("INNER", SQLPreferences.getJoinName(i), nodeT.getField("ID_PARENT"), lastAlias);
            join.setWhere(new Where(join.getJoinedTable().getField("NAME"), "=", (Object)path.get(i)));
            lastAlias = join.getAlias();
            ++i;
        }
        sel.setWhere(Where.isNull(rootT.getField("ID_PARENT")));
        sel.addSelectStar(size == 0 ? rootT : new AliasedTable(nodeT, SQLPreferences.getJoinName(size - 1)));
        List res = (List)this.execute(sel.asString(), SQLDataSource.MAP_LIST_HANDLER);
        assert (res.size() <= 1) : "Unique constraint not enforced";
        if (res.size() == 0) {
            return null;
        }
        return new SQLRow(nodeT, (Map)res.get(0));
    }

    private final SQLRow getNodeCTE(List<String> path, SQLBase base) {
        if (path.size() == 0) {
            throw new IllegalArgumentException("Empty path : use getNodeJoins()");
        }
        ArrayList<List<String>> values = new ArrayList<List<String>>(path.size());
        for (String token : path) {
            values.add(Arrays.asList(String.valueOf(values.size()), base.quoteString(token)));
        }
        SQLTable nodeT = this.getNodeRT();
        StringBuilder sb = new StringBuilder(1024);
        sb.append("with recursive path(idx, name) as (").append(SQLSyntax.get(base).getValues(values, 2)).append("),");
        sb.append("\nt as (");
        SQLSelect selectRoot = new SQLSelect(true).addSelectStar(nodeT).addRawSelect("0", "depth").setWhere(Where.isNull(nodeT.getField("ID_PARENT")));
        sb.append(selectRoot.asString()).append("\nUNION ALL\n");
        sb.append(new SQLSelect(true).addSelectStar(nodeT).addRawSelect("\"depth\" + 1", "depth").asString());
        sb.append("\nINNER JOIN t on t." + nodeT.getKey().getQuotedName() + " = " + nodeT.getField("ID_PARENT").getFieldRef());
        sb.append("\nINNER JOIN path on path.idx = t.\"depth\" and path.name = ").append(nodeT.getField("NAME").getFieldRef());
        sb.append("\n)");
        sb.append("\nselect * from t where t.\"depth\" = (select max(idx)+1 from path)");
        Map map = (Map)this.execute(sb.toString(), SQLDataSource.MAP_HANDLER);
        if (map == null) {
            return null;
        }
        map.keySet().retainAll(nodeT.getFieldsName());
        return new SQLRow(nodeT, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLRow getNode(SQLRow parentNode) {
        Object object = this.nodeLock;
        synchronized (object) {
            if (this.node == null) {
                Where parentW;
                if (this.isRoot()) {
                    parentW = Where.isNull(this.getNodeRT().getField("ID_PARENT"));
                } else {
                    Where where = parentW = parentNode == null ? null : new Where((FieldRef)this.getNodeRT().getField("ID_PARENT"), "=", parentNode.getID());
                }
                if (parentW == null) {
                    this.setNode(null);
                } else {
                    SQLSelect sel = new SQLSelect().addSelectStar(this.getNodeRT());
                    sel.setWhere(parentW.and(new Where((FieldRef)this.getNodeRT().getField("NAME"), "=", (Object)this.name())));
                    Map m = (Map)this.execute(sel.asString(), SQLDataSource.MAP_HANDLER);
                    this.setNode(m == null ? null : new SQLRow(this.getNodeRT(), m));
                }
            }
            return this.node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean createThisNode(SQLRow parentNode) throws SQLException {
        assert (this.isRoot() == (parentNode == null)) : "Either the root has a parent or a node has null parent (which shouldn't happen since we're inserting rows)";
        SQLRowValues insVals = new SQLRowValues(this.getNodeWT());
        insVals.put("ID_PARENT", parentNode == null ? SQLRowValues.SQL_EMPTY_LINK : Integer.valueOf(parentNode.getID()));
        insVals.put("NAME", this.name());
        Object object = this.nodeLock;
        synchronized (object) {
            boolean res;
            this.resetNode();
            boolean bl = res = this.getNode(parentNode) == null;
            if (res) {
                this.setNode(insVals.insert());
            }
            assert (this.node != null);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean createNode() throws SQLException {
        Iterator<SQLPreferences> iter = this.getAncestors().iterator();
        boolean created = false;
        SQLRow parentNode = null;
        while (iter.hasNext()) {
            boolean ancestorCreated;
            SQLPreferences ancestor = iter.next();
            Object object = ancestor.nodeLock;
            synchronized (object) {
                ancestorCreated = ancestor.createThisNode(parentNode);
                parentNode = ancestor.node;
            }
            created |= ancestorCreated;
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> getValues() {
        Object object = this.lock;
        synchronized (object) {
            if (this.values == null) {
                this.values = new HashMap<String, String>();
                SQLRow node = this.getNode();
                if (node != null) {
                    SQLSelect sel = new SQLSelect().addSelectStar(this.getPrefRT());
                    sel.setWhere(new Where((FieldRef)this.getPrefRT().getField("ID_NODE"), "=", node.getID()));
                    List l = (List)this.execute(sel.asString(), SQLDataSource.MAP_LIST_HANDLER);
                    for (Map r : l) {
                        this.values.put(r.get("NAME").toString(), r.get("VALUE").toString());
                    }
                }
            }
            return this.values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putSpi(String key, String value) {
        Object object = this.lock;
        synchronized (object) {
            this.changedValues.put(key, value);
            this.removedKeys.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeSpi(String key) {
        Object object = this.lock;
        synchronized (object) {
            this.removedKeys.add(key);
            this.changedValues.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getSpi(String key) {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (!this.removedKeys.contains(key)) break block5;
                return null;
            }
            if (this.changedValues.containsKey(key)) {
                return this.changedValues.get(key);
            }
            return this.getValues().get(key);
        }
    }

    private void deleteValues(Set<String> keys) {
        SQLRow node = this.getNode();
        if (node != null) {
            String keysW = keys == null ? "" : " and " + new Where(this.getPrefWT().getField("NAME"), keys).getClause();
            this.getWriteDS().execute("DELETE FROM " + this.getPrefWT().getSQLName().quote() + " where \"ID_NODE\" = " + node.getID() + keysW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            try {
                final SQLRow node = this.getNode();
                if (node != null) {
                    SQLUtils.executeAtomic(this.getWriteDS(), new ConnectionHandlerNoSetup<Object, SQLException>(){

                        @Override
                        public Object handle(SQLDataSource ds) throws SQLException {
                            SQLPreferences.this.deleteValues(null);
                            ds.execute("DELETE FROM " + SQLPreferences.this.getNodeWT().getSQLName().quote() + " where \"ID\" = " + node.getID());
                            return null;
                        }
                    });
                    this.replicate();
                    this.resetNode();
                }
            }
            catch (Exception e) {
                throw new BackingStoreException(e);
            }
            this.values = null;
            this.removedKeys.clear();
            this.changedValues.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] keysSpi() throws BackingStoreException {
        try {
            Object object = this.lock;
            synchronized (object) {
                Set<String> res;
                Set<String> committedKeys = this.getValues().keySet();
                if (this.removedKeys.isEmpty() && this.changedValues.isEmpty()) {
                    res = committedKeys;
                } else {
                    res = new HashSet<String>(committedKeys);
                    res.removeAll(this.removedKeys);
                    res.addAll(this.changedValues.keySet());
                }
                return res.toArray(new String[res.size()]);
            }
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        try {
            Object object = this.lock;
            synchronized (object) {
                SQLRow node = this.getNode();
                if (node == null) {
                    return new String[0];
                }
                int nodeID = node.getID();
                SQLSelect sel = new SQLSelect().addSelect(this.getNodeRT().getField("NAME"));
                Where w = new Where((FieldRef)this.getNodeRT().getField("ID_PARENT"), "=", nodeID);
                sel.setWhere(w);
                List names = (List)this.execute(sel.asString(), SQLDataSource.COLUMN_LIST_HANDLER);
                return names.toArray(new String[names.size()]);
            }
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
    }

    @Override
    protected SQLPreferences childSpi(String name) {
        return new SQLPreferences(this, name);
    }

    @Override
    public void sync() throws BackingStoreException {
        this.replicate();
        super.sync();
    }

    public void reset() throws BackingStoreException {
        this.replicate();
        this.resetRec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resetRec() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            AbstractPreferences[] abstractPreferencesArray = this.cachedChildren();
            int n = abstractPreferencesArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractPreferences kid = abstractPreferencesArray[n2];
                ((SQLPreferences)kid).resetRec();
                ++n2;
            }
            this.resetThis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resetThis() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            this.values = null;
            this.removedKeys.clear();
            this.changedValues.clear();
            this.resetNode();
            if (this.getNode() == null) {
                this.removeNode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncSpi() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            this.flushSpi();
            this.resetThis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushSpi() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.nodeExists("")) {
                return;
            }
            try {
                SQLUtils.executeAtomic(this.getWriteDS(), new ConnectionHandlerNoSetup<Object, SQLException>(){

                    @Override
                    public Object handle(SQLDataSource ds) throws SQLException {
                        SQLPreferences.this.flushTxn();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new BackingStoreException(e);
            }
        }
    }

    protected final void flushTxn() throws SQLException {
        assert (Thread.holdsLock(this.lock));
        boolean masterChanged = this.createNode();
        if (this.removedKeys.size() > 0 || this.changedValues.size() > 0) {
            this.deleteValues(CollectionUtils.union(this.removedKeys, this.changedValues.keySet()));
            if (this.values != null) {
                this.values.keySet().removeAll(this.removedKeys);
            }
            this.removedKeys.clear();
            if (this.changedValues.size() > 0) {
                int nodeID = this.getNode().getID();
                ArrayList<String> insValues = new ArrayList<String>(this.changedValues.size());
                for (Map.Entry<String, String> e : this.changedValues.entrySet()) {
                    insValues.add("(" + nodeID + ", " + this.getPrefWT().getBase().quoteString(e.getKey()) + ", " + this.getPrefWT().getBase().quoteString(e.getValue()) + ")");
                    if (this.values == null) continue;
                    this.values.put(e.getKey(), e.getValue());
                }
                SQLRowValues.insertCount(this.getPrefWT(), "(\"ID_NODE\", \"NAME\", \"VALUE\") VALUES" + CollectionUtils.join(insValues, ", "));
                this.changedValues.clear();
            }
            masterChanged = true;
        }
        if (masterChanged) {
            this.replicate();
        }
    }
}

