/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.CollectionUtils;

abstract class AbstractPath<T extends AbstractPath<T>> {
    AbstractPath() {
    }

    public final SQLTable getFirst() {
        return this.getTable(0);
    }

    public final SQLTable getLast() {
        return this.getTable(this.getTables().size() - 1);
    }

    public final SQLTable getTable(int i) {
        return this.getTables().get(i);
    }

    public abstract List<SQLTable> getTables();

    public final int length() {
        return this.getSteps().size();
    }

    public final T append(Path p) {
        this.check(p.getFirst());
        return this._append(p);
    }

    protected final void check(SQLTable t) {
        if (this.getLast() != t) {
            throw new IllegalArgumentException("this ends at " + this.getLast() + " while the other begins at " + t);
        }
    }

    protected abstract T _append(Path var1);

    public abstract T add(Step var1);

    public final T add(SQLTable destTable) {
        return this.add(destTable, Link.Direction.ANY);
    }

    public final T add(SQLTable destTable, Link.Direction dir) {
        return this.add(Step.create(this.getLast(), destTable, dir));
    }

    public final T addTable(String tableName) {
        return this.addTable(tableName, Link.Direction.ANY, false);
    }

    public final T addTable(String tableName, Link.Direction dir, boolean onlyOne) {
        return this.add(dir, null, tableName, null, onlyOne);
    }

    public final T addTables(String ... names) {
        return this.addTables(Arrays.asList(names));
    }

    public abstract T addTables(List<String> var1);

    public final T addForeignTable(String tableName) {
        return this.addForeignTable(tableName, null);
    }

    public final T addForeignTable(String tableName, String rootName) {
        return this.add(Link.Direction.FOREIGN, null, tableName, rootName, true);
    }

    public final T add(SQLField fField) {
        return this.add(fField, Link.Direction.ANY);
    }

    public final T add(SQLField fField, Link.Direction direction) {
        return this.add(Step.create(this.getLast(), fField, direction));
    }

    public final T addStepWithFields(Collection<SQLField> fields) {
        HashSet<Link> links = new HashSet<Link>(fields.size());
        DatabaseGraph graph = this.getFirst().getDBSystemRoot().getGraph();
        for (SQLField f : fields) {
            links.add(graph.getForeignLink(f));
        }
        return this.add(links);
    }

    public abstract T addForeignFields(String ... var1);

    public final T addForeignField(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("Missing field name");
        }
        return this.add(Link.Direction.FOREIGN, Collections.singletonList(fieldName), null, null, true);
    }

    public final T addReferentField(String fieldName) {
        return this.addReferent(fieldName, null, null);
    }

    public final T addReferentTable(String tableName) {
        return this.addReferent(null, tableName, null);
    }

    public final T addReferent(String fieldName, String tableName, String rootName) {
        return this.add(Link.Direction.REFERENT, fieldName == null ? null : Collections.singletonList(fieldName), tableName, rootName, true);
    }

    public final T add(Link.Direction dir, List<String> fieldsNames, String tableName, String rootName, boolean onlyOne) {
        Set<Link> links = this.getLast().getDBSystemRoot().getGraph().getLinks(this.getLast(), dir, onlyOne, new Link.NamePredicate(this.getLast(), rootName, tableName, fieldsNames));
        return this.add(links, dir);
    }

    public final T add(Collection<Link> links) {
        return this.add(links, Link.Direction.ANY);
    }

    public final T add(Collection<Link> links, Link.Direction dir) {
        Step step;
        if (dir == Link.Direction.ANY) {
            step = Step.create(this.getLast(), links);
        } else {
            step = Step.create(CollectionUtils.fillMap(new HashMap(), links, dir));
            if (step.getFrom() != this.getLast()) {
                throw new IllegalArgumentException("links from " + step.getFrom() + " not " + this.getLast());
            }
        }
        return this.add(step);
    }

    public final T add(Link item) {
        return this.add(item, Link.Direction.ANY);
    }

    public final T add(Link l, Link.Direction direction) {
        return this.add(Step.create(this.getLast(), l, direction));
    }

    public abstract List<Step> getSteps();
}

