/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.StringUtils;

public class GenerationMvtSepa
extends GenerationEcritures {
    private long montant;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    private final List<SQLRow> sepaRows;
    private SQLRowAccessor banque;

    public GenerationMvtSepa(List<SQLRow> sepaRows) {
        this.sepaRows = sepaRows;
    }

    public void genere() throws Exception {
        System.err.println("g\u00e9n\u00e9ration des ecritures de r\u00e8glement d'un prelevement client du mouvement " + this.idMvt);
        ArrayList<Integer> pieceIDs = new ArrayList<Integer>();
        for (SQLRow rowSepa : this.sepaRows) {
            int idCompteClient;
            this.montant = rowSepa.getLong("MONTANT");
            this.date = rowSepa.getDate("DATE").getTime();
            this.banque = rowSepa.getForeign("ID_" + BanqueSQLElement.TABLENAME);
            SQLRow foreignPiece = rowSepa.getForeign("ID_MOUVEMENT").getForeign("ID_PIECE");
            this.nom = "Pr\u00e9l\u00e8vement " + foreignPiece.getString("NOM");
            SQLRow clientRow = rowSepa.getForeign("ID_CLIENT");
            SQLRowValues rowVals = new SQLRowValues(base.getTable("ENCAISSER_MONTANT"));
            rowVals.put("MONTANT", this.montant);
            rowVals.put("ID_CLIENT", clientRow != null ? Integer.valueOf(((SQLRowAccessor)clientRow).getID()) : null);
            rowVals.put("TIERS", rowSepa.getString("TIERS"));
            rowVals.put("DATE", this.date);
            SQLRowValues rowValsRegl = new SQLRowValues(base.getTable("MODE_REGLEMENT"));
            rowValsRegl.put("ID_TYPE_REGLEMENT", 10);
            SQLRow copy = rowValsRegl.insert();
            rowVals.put("ID_MODE_REGLEMENT", copy.getID());
            rowVals.put("NOM", this.nom);
            SQLRow rowEncaisse = rowVals.insert();
            SQLRowValues rowValsElt = new SQLRowValues(base.getTable("ENCAISSER_MONTANT_ELEMENT"));
            rowValsElt.put("MONTANT_REGLE", this.montant);
            rowValsElt.put("ID_ENCAISSER_MONTANT", rowEncaisse.getID());
            rowValsElt.put("ID_MOUVEMENT_ECHEANCE", rowSepa.getForeignID("ID_MOUVEMENT"));
            rowValsElt.insert();
            this.idMvt = this.getNewMouvement(rowEncaisse.getTable().getName(), rowEncaisse.getID(), rowSepa.getForeignID("ID_MOUVEMENT"), ((SQLRowAccessor)foreignPiece).getID());
            rowEncaisse.createEmptyUpdateRow().put("ID_MOUVEMENT", this.idMvt).commit();
            this.putValue("ID_MOUVEMENT", new Integer(this.idMvt));
            this.putValue("DATE", new Date(this.date.getTime()));
            this.putValue("NOM", this.nom);
            if (this.banque == null || this.banque.isUndefined() || this.banque.isForeignEmpty("ID_JOURNAL")) {
                this.fillJournalBanqueFromRow(rowSepa);
            } else {
                int idJrnl = this.banque.getForeignID("ID_JOURNAL");
                this.putValue("ID_JOURNAL", idJrnl);
            }
            this.putValue("NOM", String.valueOf(this.nom) + " " + foreignPiece.getString("NOM") + " " + StringUtils.limitLength(clientRow.getString("NOM"), 20));
            SQLRow rowCptTiers = rowSepa.getForeign("ID_COMPTE_PCE_TIERS");
            int n = idCompteClient = rowCptTiers != null && !rowCptTiers.isUndefined() ? ((SQLRowAccessor)rowCptTiers).getID() : -1;
            if (idCompteClient == -1) {
                if (clientRow != null) {
                    idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
                }
                if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                    idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                }
            }
            this.putValue("ID_COMPTE_PCE", new Integer(idCompteClient));
            this.putValue("DEBIT", new Long(0L));
            this.putValue("CREDIT", new Long(rowSepa.getLong("MONTANT")));
            this.ajoutEcriture();
            this.fillCompteBanqueFromRow(rowSepa, "VenteCheque", false);
            this.putValue("NOM", this.nom);
            this.putValue("DEBIT", new Long(this.montant));
            this.putValue("CREDIT", new Long(0L));
            this.ajoutEcriture();
            pieceIDs.add(((SQLRowAccessor)foreignPiece).getID());
            System.err.println("Ecritures g\u00e9n\u00e9r\u00e9es pour le mouvement " + this.idMvt);
        }
        this.lettrageAuto(pieceIDs, this.date);
    }
}

