/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.employe.panel;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class ObjectifTableModel
extends AbstractTableModel {
    List<SQLField> cols = new ArrayList<SQLField>();
    SQLTable tableObjectif = Configuration.getInstance().getRoot().findTable("OBJECTIF_COMMERCIAL");
    List<SQLRowValues> values = new ArrayList<SQLRowValues>();

    public ObjectifTableModel() {
        this.cols.add(this.tableObjectif.getField("MOIS"));
        this.cols.add(this.tableObjectif.getField("CHIFFRE_AFFAIRE"));
        this.cols.add(this.tableObjectif.getField("POURCENT_MARGE"));
        this.cols.add(this.tableObjectif.getField("MARGE_HT"));
    }

    @Override
    public int getColumnCount() {
        return this.cols.size();
    }

    @Override
    public String getColumnName(int column) {
        return Configuration.getInstance().getTranslator().getTitleFor(this.cols.get(column));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.cols.get(columnIndex).getType().getJavaType();
    }

    @Override
    public int getRowCount() {
        return this.values.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.values.get(rowIndex).getObject(this.cols.get(columnIndex).getName());
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        long result;
        Number decimal;
        super.setValueAt(aValue, rowIndex, columnIndex);
        SQLRowValues rowValuesAt = this.getRowValuesAt(rowIndex);
        if (columnIndex == 1 && (decimal = (BigDecimal)rowValuesAt.getObject(this.cols.get(2).getName())) != null) {
            result = Math.round(((BigDecimal)decimal).doubleValue() * (double)((Long)aValue).longValue() / 100.0);
            rowValuesAt.put(this.cols.get(3).getName(), result);
        }
        if (columnIndex == 2 && (decimal = (Long)rowValuesAt.getObject(this.cols.get(1).getName())) != null) {
            result = Math.round((double)((Long)decimal).longValue() * ((BigDecimal)aValue).doubleValue() / 100.0);
            rowValuesAt.put(this.cols.get(3).getName(), result);
        }
        if (columnIndex == 3 && (decimal = (Long)rowValuesAt.getObject(this.cols.get(1).getName())) != null) {
            double result2 = ((Long)aValue).doubleValue() / ((Long)decimal).doubleValue() * 100.0;
            rowValuesAt.put(this.cols.get(2).getName(), new BigDecimal(result2));
        }
        rowValuesAt.put(this.cols.get(columnIndex).getName(), aValue);
        try {
            rowValuesAt.update();
        }
        catch (SQLException exn) {
            exn.printStackTrace();
        }
        this.fireTableDataChanged();
    }

    public void loadData(int idCommercial, Integer annee) {
        if (idCommercial <= 1 || annee == null) {
            this.values.clear();
        } else {
            SQLSelect sel = new SQLSelect(this.tableObjectif.getBase());
            sel.addSelectStar(this.tableObjectif);
            Where w = new Where((FieldRef)this.tableObjectif.getField("ID_COMMERCIAL"), "=", idCommercial);
            w = w.and(new Where((FieldRef)this.tableObjectif.getField("ANNEE"), "=", (Object)annee));
            sel.setWhere(w);
            sel.addFieldOrder(this.tableObjectif.getOrderField());
            List<SQLRow> rows = SQLRowListRSH.execute(sel);
            ArrayList<SQLRowValues> rowValuesList = new ArrayList<SQLRowValues>();
            for (SQLRow sqlRow : rows) {
                rowValuesList.add(sqlRow.asRowValues());
            }
            this.values.clear();
            this.values.addAll(rowValuesList);
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 || columnIndex == 2 || columnIndex == 3;
    }

    public SQLRowValues getRowValuesAt(int index) {
        if (index >= 0) {
            return this.values.get(index);
        }
        return null;
    }
}

