/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.Order;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Tuple3;

public class CurrencyConverter {
    private String companyCurrencyCode;
    private final DBRoot root;
    private boolean useCache = false;
    private String baseCurrencyCode;
    Map<Tuple3<String, String, Date>, Tuple2<BigDecimal, BigDecimal>> cacheBiased = new HashMap<Tuple3<String, String, Date>, Tuple2<BigDecimal, BigDecimal>>();
    Map<Tuple3<String, String, Date>, Tuple2<BigDecimal, BigDecimal>> cacheNotBiased = new HashMap<Tuple3<String, String, Date>, Tuple2<BigDecimal, BigDecimal>>();

    public CurrencyConverter(DBRoot rootSociete, String companyCurrencyCode, String baseCurrencyCode) {
        this.companyCurrencyCode = companyCurrencyCode == null || companyCurrencyCode.isEmpty() ? "EUR" : companyCurrencyCode.trim().toUpperCase();
        this.baseCurrencyCode = baseCurrencyCode;
        this.root = rootSociete;
    }

    public CurrencyConverter() {
        this(ComptaPropsConfiguration.getInstanceCompta().getRootSociete(), ComptaPropsConfiguration.getInstanceCompta().getCurrency().getCode(), "EUR");
    }

    public String getCompanyCurrencyCode() {
        return this.companyCurrencyCode;
    }

    public String getBaseCurrencyCode() {
        return this.baseCurrencyCode;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public BigDecimal convert(BigDecimal amount, String from, String to) {
        return this.convert(amount, from, to, Calendar.getInstance().getTime());
    }

    public BigDecimal convert(BigDecimal amount, String from, String to, Date date) {
        return this.convert(amount, from, to, date, false);
    }

    public void clearCache() {
        this.cacheBiased.clear();
        this.cacheNotBiased.clear();
    }

    public BigDecimal convert(BigDecimal amount, String from, String to, Date date, boolean useBiased) {
        Tuple3<String, String, Date> key;
        if (from.equalsIgnoreCase(to)) {
            return amount;
        }
        if (amount.signum() == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal r1 = null;
        BigDecimal r2 = null;
        if (this.useCache) {
            Tuple2<BigDecimal, BigDecimal> value;
            key = Tuple3.create(from, to, date);
            if (useBiased && this.cacheBiased.containsKey(key)) {
                value = this.cacheBiased.get(key);
                r1 = value.get0();
                r2 = value.get1();
            } else if (!useBiased && this.cacheNotBiased.containsKey(key)) {
                value = this.cacheNotBiased.get(key);
                r1 = value.get0();
                r2 = value.get1();
            }
        }
        if (r1 == null || r2 == null) {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            c.setTimeInMillis(date.getTime());
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            Date d = c.getTime();
            List<SQLRow> rowsFrom = this.getRates(from, d);
            List<SQLRow> rowsTo = this.getRates(to, d);
            ArrayList<SQLRow> rows = new ArrayList<SQLRow>();
            rows.addAll(rowsTo);
            rows.addAll(rowsFrom);
            for (SQLRow sqlRow : rows) {
                if (sqlRow.getString("DST").equals(from)) {
                    if (useBiased) {
                        if (r1 == null) {
                            r1 = sqlRow.getBigDecimal("TAUX_COMMERCIAL");
                        }
                    } else {
                        r1 = sqlRow.getBigDecimal("TAUX");
                    }
                }
                if (!sqlRow.getString("DST").equals(to)) continue;
                if (useBiased) {
                    if (r2 != null) continue;
                    r2 = sqlRow.getBigDecimal("TAUX_COMMERCIAL");
                    continue;
                }
                r2 = sqlRow.getBigDecimal("TAUX");
            }
            if (from.equals(this.baseCurrencyCode)) {
                r1 = BigDecimal.ONE;
            }
            if (to.equals(this.baseCurrencyCode)) {
                r2 = BigDecimal.ONE;
            }
            if (r1 == null || r2 == null) {
                ArrayList<SQLRow> rowsDevise = new ArrayList<SQLRow>();
                if (rowsTo.isEmpty() || rowsFrom.isEmpty()) {
                    SQLSelect sel = new SQLSelect();
                    sel.addSelectStar(this.root.findTable("DEVISE"));
                    rowsDevise.addAll(SQLRowListRSH.execute(sel));
                }
                if (r2 == null) {
                    for (SQLRow sqlRow : rowsDevise) {
                        if (!sqlRow.getString("CODE").equalsIgnoreCase(to)) continue;
                        BigDecimal bigDecimal = r2 = useBiased ? sqlRow.getBigDecimal("TAUX_COMMERCIAL") : sqlRow.getBigDecimal("TAUX");
                    }
                }
                if (r1 == null) {
                    for (SQLRow sqlRow : rowsDevise) {
                        if (!sqlRow.getString("CODE").equalsIgnoreCase(from)) continue;
                        BigDecimal bigDecimal = r1 = useBiased ? sqlRow.getBigDecimal("TAUX_COMMERCIAL") : sqlRow.getBigDecimal("TAUX");
                    }
                }
            }
        }
        if (r1 == null) {
            throw new IllegalStateException("No conversion rate for " + from);
        }
        if (r2 == null) {
            throw new IllegalStateException("No conversion rate for " + to);
        }
        if (this.useCache) {
            key = Tuple3.create(from, to, date);
            if (useBiased) {
                this.cacheBiased.put(key, Tuple2.create(r1, r2));
            } else {
                this.cacheNotBiased.put(key, Tuple2.create(r1, r2));
            }
        }
        if (r1.equals(BigDecimal.ZERO)) {
            r1 = BigDecimal.ONE;
        }
        BigDecimal result = amount.multiply(r2, DecimalUtils.HIGH_PRECISION).divide(r1, DecimalUtils.HIGH_PRECISION);
        return result;
    }

    public List<SQLRow> getRates(String currencyCode, Date d) {
        SQLSelect select = new SQLSelect();
        SQLTable t = this.root.getTable("DEVISE_HISTORIQUE");
        select.addAllSelect(t, Arrays.asList("ID", "DATE", "SRC", "DST", "TAUX", "TAUX_COMMERCIAL"));
        Where w = new Where((FieldRef)t.getField("SRC"), "=", (Object)this.baseCurrencyCode);
        w = w.and(new Where((FieldRef)t.getField("DST"), "=", (Object)currencyCode));
        w = w.and(new Where((FieldRef)t.getField("DATE"), "<=", (Object)d));
        select.setWhere(w);
        select.addFieldOrder(t.getField("DATE"), Order.desc());
        select.setLimit(2);
        List<SQLRow> rows = SQLRowListRSH.execute(select);
        return rows;
    }
}

