/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.report;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.erp.core.customerrelationship.customer.report.ReportingCommercialItem;

public class ReportingCommercial {
    private String commercial;
    private Date debut;
    private Date fin;
    private Map<String, ReportingCommercialItem> items = new HashMap<String, ReportingCommercialItem>();

    public ReportingCommercial(String commercial, Date debut, Date fin) {
        this.commercial = commercial;
        this.debut = debut;
        this.fin = fin;
    }

    public BigDecimal getTotal() {
        BigDecimal total = BigDecimal.ZERO;
        for (ReportingCommercialItem item : this.items.values()) {
            total = total.add(item.getCa());
        }
        return total;
    }

    public void add(ReportingCommercialItem item) {
        this.items.put(item.getClient(), item);
    }

    public void add(String client, BigDecimal ht) {
        if (this.items.containsKey(client)) {
            this.items.get(client).addCA(ht);
        } else {
            ReportingCommercialItem reportingCommercialItem = new ReportingCommercialItem(client);
            reportingCommercialItem.addCA(ht);
            this.items.put(client, reportingCommercialItem);
        }
    }

    public Collection<ReportingCommercialItem> getItems() {
        return this.items.values();
    }

    public String getCommercial() {
        return this.commercial;
    }

    public Date getDebut() {
        return this.debut;
    }

    public Date getFin() {
        return this.fin;
    }
}

