/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.element;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import org.openconcerto.erp.core.customerrelationship.customer.element.ClientNormalSQLElement;
import org.openconcerto.erp.core.customerrelationship.customer.element.CustomerGroup;
import org.openconcerto.erp.core.customerrelationship.customer.element.CustomerSQLComponent;
import org.openconcerto.erp.core.edm.AttachmentAction;
import org.openconcerto.erp.core.reports.history.ui.HistoriqueClientFrame;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.ui.light.SimpleTextLine;

public class CustomerSQLElement
extends ClientNormalSQLElement {
    public CustomerSQLElement() {
        CustomerGroup group = new CustomerGroup();
        GlobalMapper.getInstance().map("customerrelationship.customer.default", group);
        this.setDefaultGroup(group);
        RowAction.PredicateRowAction actionAttachment = new RowAction.PredicateRowAction(new AttachmentAction().getAction(), true);
        actionAttachment.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionAttachment);
        RowAction.PredicateRowAction actionHistory = new RowAction.PredicateRowAction(new AbstractAction("Historique client"){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoriqueClientFrame histoFrame = new HistoriqueClientFrame();
                int idClient = IListe.get(e).getSelectedId();
                histoFrame.selectId(idClient);
                histoFrame.setVisible(true);
            }
        }, true);
        actionHistory.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionHistory);
    }

    @Override
    public SQLComponent createComponent() {
        CustomerSQLComponent c = new CustomerSQLComponent(this);
        c.startTabGroupAfter("customerrelationship.customer.identifier");
        return c;
    }

    @Override
    protected List<String> getListFields() {
        SQLPreferences prefs;
        List<String> fields = super.getListFields();
        if (this.getTable().contains("GROUPE")) {
            fields.add("GROUPE");
        }
        if ((prefs = new SQLPreferences(this.getTable().getDBRoot())).getBoolean(GestionCommercialeGlobalPreferencePanel.CATEGORIE_COMPTABLE_SPEC, false)) {
            fields.add("ID_CATEGORIE_COMPTABLE");
        }
        fields.add("SOLDE_COMPTE");
        fields.add("REMIND_DATE");
        fields.add("OBSOLETE");
        return fields;
    }

    @Override
    protected void fillDataPanel(String sessionToken, List<SQLRowAccessor> selection, LightUIPanel dataPanel) {
        SQLFieldTranslator translator = this.getDirectory().getTranslator();
        SQLRowAccessor sqlRow = selection.get(0);
        int rowId = sqlRow.getID();
        LightUILine mainLine = new LightUILine();
        LightUIPanel mainLinePanel = new LightUIPanel(String.valueOf(dataPanel.getId()) + ".main.line." + rowId);
        mainLinePanel.setWeightX(1);
        SimpleTextLine spacer = new SimpleTextLine("", true, 2, 2);
        spacer.setMarginBottom(4);
        String name = sqlRow.getString("NOM");
        mainLinePanel.addChild(new SimpleTextLine(name, true, 2));
        SimpleTextLine titleSituationContact = new SimpleTextLine("Coordonn\u00e9es du client", true, 2, 2);
        titleSituationContact.setMarginTop(10);
        mainLinePanel.addChild(titleSituationContact);
        this.addFieldToPanel("TEL", mainLinePanel, sqlRow, translator, true, "non renseign\u00e9");
        this.addFieldToPanel("MAIL", mainLinePanel, sqlRow, translator, true, "non renseign\u00e9");
        mainLine.addChild(mainLinePanel);
        dataPanel.addChild(mainLine);
    }
}

