/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.config.MenuAndActions;
import org.openconcerto.erp.config.MenuManager;
import org.openconcerto.erp.core.common.ui.StatusPanel;
import org.openconcerto.erp.panel.UserExitConf;
import org.openconcerto.erp.panel.UserExitPanel;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.task.TodoListPanel;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.ui.AutoHideTabbedPane;
import org.openconcerto.ui.MenuUtils;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.state.WindowStateManager;
import org.openconcerto.utils.JImage;
import org.openconcerto.utils.OSXAdapter;

public class MainFrame
extends JFrame {
    public static final String STRUCTURE_MENU = "menu.organization";
    public static final String PAYROLL_MENU = "menu.payroll";
    public static final String PAYMENT_MENU = "menu.payment";
    public static final String STATS_MENU = "menu.stats";
    public static final String DECLARATION_MENU = "menu.report";
    public static final String STATE_MENU = "menu.accounting";
    public static final String LIST_MENU = "menu.list";
    public static final String CREATE_MENU = "menu.create";
    public static final String FILE_MENU = "menu.file";
    public static final String HELP_MENU = "menu.help";
    public static final String PREFS_MENU_ITEM = "preferences";
    public static final String QUIT_MENU_ITEM = "quit";
    public static final String ABOUT_MENU_ITEM = "information";
    private static final List<Runnable> runnables = new ArrayList<Runnable>();
    @GuardedBy(value="MainFrame")
    private static MainFrame instance = null;
    private final AutoHideTabbedPane tabContainer;
    private TodoListPanel todoPanel;
    private JImage image;

    public static synchronized MainFrame getInstance() {
        return instance;
    }

    public static synchronized MainFrame resetInstance() {
        MainFrame res = instance;
        MainFrame.setInstance(null);
        if (res != null) {
            res.setVisible(false);
            res.dispose();
        }
        return res;
    }

    private static synchronized void setInstance(MainFrame f) {
        assert (SwingUtilities.isEventDispatchThread());
        if (f != null && instance != null) {
            throw new IllegalStateException("More than one main frame");
        }
        instance = f;
        if (f != null) {
            for (Runnable r : runnables) {
                r.run();
            }
            runnables.clear();
        }
    }

    public static void invoke(final Runnable r) {
        SwingThreadUtils.invoke(new Runnable(){

            @Override
            public void run() {
                if (MainFrame.getInstance() == null) {
                    runnables.add(r);
                } else {
                    r.run();
                }
            }
        });
    }

    public TodoListPanel getTodoPanel() {
        return this.todoPanel;
    }

    public MainFrame(PropsConfiguration conf) {
        Image im;
        String confSuffix;
        Dimension minSize;
        this.setIconImage(new ImageIcon(MainFrame.class.getResource("frameicon.png")).getImage());
        Container co = this.getContentPane();
        co.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.image = new JImage(ComptaBasePropsConfiguration.class.getResource("logo.png"));
        this.image.setBackground(Color.WHITE);
        this.image.check();
        co.add((Component)this.image, c);
        c.weighty = 0.0;
        ++c.gridy;
        c.fill = 1;
        co.add((Component)new JSeparator(0), c);
        ++c.gridy;
        c.weighty = 1.0;
        this.tabContainer = new AutoHideTabbedPane();
        co.add((Component)this.tabContainer, c);
        if (!Gestion.isMinimalMode()) {
            this.todoPanel = new TodoListPanel(UserManager.getInstance());
            this.getTabbedPane().addTab("T\u00e2ches", this.todoPanel);
            minSize = new Dimension(800, 600);
            confSuffix = "";
        } else {
            minSize = null;
            confSuffix = "-minimal";
        }
        c.weighty = 0.0;
        ++c.gridy;
        c.fill = 2;
        co.add((Component)StatusPanel.getInstance(), c);
        if (minSize == null) {
            this.pack();
            minSize = new Dimension(this.getSize());
        }
        this.setMinimumSize(minSize);
        File confFile = new File(conf.getConfDir(), "Configuration" + File.separator + "Frame" + File.separator + "mainFrame" + confSuffix + ".xml");
        new WindowStateManager(this, confFile).loadState();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                MainFrame.this.quit();
            }
        });
        MainFrame.setInstance(this);
        Thread dbConn = conf.createDBCheckThread(this, new Runnable(){

            @Override
            public void run() {
                UserExitPanel.exit(UserExitConf.DEFAULT);
            }
        });
        dbConn.start();
        Image image = im = conf instanceof ComptaPropsConfiguration ? ((ComptaPropsConfiguration)conf).getCustomLogo() : null;
        if (im != null) {
            this.image.setImage(im);
        }
    }

    public final void initMenuBar() {
        final MenuManager mm = MenuManager.getInstance();
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MainFrame.this.setJMenuBar(MainFrame.this.createMenu(mm));
                MainFrame.this.getLayeredPane().revalidate();
            }
        };
        mm.addPropertyChangeListener(listener);
        listener.propertyChange(null);
    }

    private final JMenuBar createMenu(MenuManager mm) {
        JMenuBar result = new JMenuBar();
        Group g = mm.getGroup();
        int i = 0;
        while (i < g.getSize()) {
            Item item = g.getItem(i);
            if (item.getLocalHint().isVisible() && UserRightsManager.getCurrentUserRights().haveRight("MENU_ACCESS", item.getId())) {
                result.add(this.createJMenuFrom(item, mm));
            }
            ++i;
        }
        return result;
    }

    private final JMenu createJMenuFrom(Item item, MenuManager mm) {
        Color c;
        String menuLabel;
        assert (item.getLocalHint().isVisible());
        String id = item.getId();
        String name = mm.getLabelForId(id);
        if (name == null || name.trim().isEmpty()) {
            menuLabel = id;
            c = new Color(200, 65, 20);
        } else {
            menuLabel = name;
            c = null;
        }
        assert (menuLabel != null);
        JMenu m = new JMenu(menuLabel);
        if (c != null) {
            m.setForeground(c);
        }
        if (item instanceof Group) {
            this.createMenuItemsRec(mm, m, Collections.emptyList(), (Group)item);
        } else if (UserRightsManager.getCurrentUserRights().haveRight("MENU_ACCESS", item.getId())) {
            m.add(this.createJMenuItemForId(id, mm));
        }
        return m;
    }

    private final void createMenuItemsRec(MenuManager mm, JMenu topLevelMenu, List<String> path, Group g) {
        assert (g.getLocalHint().isVisible());
        int i = 0;
        while (i < g.getSize()) {
            Item child = g.getItem(i);
            if (child.getLocalHint().isVisible() && UserRightsManager.getCurrentUserRights().haveRight("MENU_ACCESS", child.getId())) {
                List<String> newPath;
                if (child instanceof Group) {
                    newPath = new ArrayList<String>(path);
                    newPath.add(child.getId());
                    this.createMenuItemsRec(mm, topLevelMenu, newPath, (Group)child);
                } else {
                    if (path.size() % 2 == 0) {
                        newPath = new ArrayList<String>(path);
                        newPath.add(null);
                    } else {
                        newPath = path;
                    }
                    MenuUtils.addMenuItem(this.createJMenuItemForId(child.getId(), mm), topLevelMenu, newPath);
                }
            }
            ++i;
        }
    }

    public static String getFirstNonEmpty(List<String> l) {
        for (String s : l) {
            if (s == null || s.trim().isEmpty()) continue;
            return s;
        }
        return null;
    }

    private final JMenuItem createJMenuItemForId(final String id, MenuManager mm) {
        Color fg;
        Action action;
        String mngrLabel = mm.getLabelForId(id);
        Action mngrAction = mm.getActionForId(id);
        String mngrActionName = mngrAction == null || mngrAction.getValue("Name") == null ? null : mngrAction.getValue("Name").toString();
        String label = MainFrame.getFirstNonEmpty(Arrays.asList(mngrLabel, mngrActionName, id));
        assert (label != null);
        if (mngrAction == null) {
            action = new AbstractAction(label){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(MainFrame.this, "No action for " + id);
                }
            };
            fg = new Color(200, 65, 95);
        } else {
            action = mngrAction;
            if (mngrActionName == null) {
                action.putValue("Name", label);
            }
            fg = label.equals(id) ? new Color(20, 65, 200) : null;
        }
        JMenuItem res = new JMenuItem(action);
        res.setHideActionText(true);
        res.setText(label);
        if (fg != null) {
            res.setForeground(fg);
        }
        return res;
    }

    public JMenuItem addMenuItem(Action action, String ... path) {
        return this.addMenuItem(action, Arrays.asList(path));
    }

    public JMenuItem addMenuItem(Action action, List<String> path) throws IllegalArgumentException {
        if (path.size() == 0 || path.size() % 2 != 0) {
            throw new IllegalArgumentException("Path should be of the form menu/group/menu/group/... : " + path);
        }
        JMenu topLevelMenu = this.getMenu(path.get(0));
        return MenuUtils.addMenuItem(action, topLevelMenu, path.subList(1, path.size()));
    }

    private JMenu getMenu(String name) {
        JMenu res;
        JMenu existing = MenuUtils.findChild(this.getJMenuBar(), name, JMenu.class);
        if (existing == null) {
            res = new JMenu(name);
            this.getJMenuBar().add((Component)res, this.getJMenuBar().getComponentCount() - 1);
        } else {
            res = existing;
        }
        return res;
    }

    public void removeMenuItem(JMenuItem item) throws IllegalArgumentException {
        if (SwingThreadUtils.getAncestorOrSelf(JMenuBar.class, item) != this.getJMenuBar()) {
            throw new IllegalArgumentException("Item not in this menu " + item);
        }
        MenuUtils.removeMenuItem(item);
    }

    public void registerDesktopEvents(MenuAndActions menuAndActions) {
        if (!this.registerAWTDesktopEvents(menuAndActions)) {
            this.registerForMacOSXEvents(menuAndActions);
        }
    }

    private boolean registerAWTDesktopEvents(MenuAndActions menuAndActions) {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        boolean quitHandled = this.registerAWTDesktopEvent(desktop, "QuitHandler", "APP_QUIT_HANDLER", menuAndActions, QUIT_MENU_ITEM);
        boolean aboutHandled = this.registerAWTDesktopEvent(desktop, "AboutHandler", "APP_ABOUT", menuAndActions, ABOUT_MENU_ITEM);
        boolean prefsHandled = this.registerAWTDesktopEvent(desktop, "PreferencesHandler", "APP_PREFERENCES", menuAndActions, PREFS_MENU_ITEM);
        return quitHandled && aboutHandled && prefsHandled;
    }

    private boolean registerAWTDesktopEvent(Desktop desktop, String handlerClassName, String desktopActionName, final MenuAndActions menuAndActions, final String menuActionName) {
        Desktop.Action appPrefsAction;
        try {
            appPrefsAction = Desktop.Action.valueOf(desktopActionName);
        }
        catch (Exception e) {
            return false;
        }
        if (!desktop.isSupported(appPrefsAction)) {
            return false;
        }
        try {
            Class<?> prefHandlerClass = Class.forName("java.awt.desktop." + handlerClassName);
            Object prefHandler = Proxy.newProxyInstance(prefHandlerClass.getClassLoader(), new Class[]{prefHandlerClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    menuAndActions.getAction(menuActionName).actionPerformed(null);
                    return null;
                }
            });
            desktop.getClass().getMethod("set" + handlerClassName, prefHandlerClass).invoke((Object)desktop, prefHandler);
            menuAndActions.setMenuItemVisible(menuActionName, false);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public void registerForMacOSXEvents(MenuAndActions menuAndActions) {
        if (Gestion.MAC_OS_X) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod(QUIT_MENU_ITEM, new Class[0]));
                OSXAdapter.setAboutHandler(this, this.getClass().getDeclaredMethod("about", new Class[0]));
                OSXAdapter.setPreferencesHandler(this, this.getClass().getDeclaredMethod(PREFS_MENU_ITEM, new Class[0]));
                menuAndActions.setMenuItemVisible(QUIT_MENU_ITEM, false);
                menuAndActions.setMenuItemVisible(ABOUT_MENU_ITEM, false);
                menuAndActions.setMenuItemVisible(PREFS_MENU_ITEM, false);
            }
            catch (Exception e) {
                System.err.println("Error while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public final void preferences() {
        MenuManager.getInstance().getActionForId(PREFS_MENU_ITEM).actionPerformed(null);
    }

    @Deprecated
    public final void about() {
        MenuManager.getInstance().getActionForId(ABOUT_MENU_ITEM).actionPerformed(null);
    }

    public boolean quit() {
        if (this.getTodoPanel() != null) {
            this.getTodoPanel().stopUpdate();
        }
        Gestion.askForExit();
        return false;
    }

    public final AutoHideTabbedPane getTabbedPane() {
        return this.tabContainer;
    }
}

