/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.text;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class FixedWidthOuputer {
    private final PrintStream stream;
    private final String lineDelimiter;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final String encoding;
    private int lineCount = 0;

    public FixedWidthOuputer(String encoding, String lineDelimiter) throws UnsupportedEncodingException {
        this.lineDelimiter = lineDelimiter;
        this.encoding = encoding;
        this.stream = new PrintStream((OutputStream)this.out, false, encoding);
    }

    public void addLine() {
        this.lineCount = 0;
        this.stream.append(this.lineDelimiter);
    }

    public String getContent() {
        try {
            return this.out.toString(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void addSpace(int n) {
        int i = 0;
        while (i < n) {
            this.stream.append(' ');
            ++i;
        }
        this.lineCount += n;
    }

    public void add(String string, int size) {
        this.addLeft(string, size, ' ');
    }

    private void addLeft(String string, int size, char c) {
        int length = string.length();
        int i = 0;
        while (i < size) {
            if (i < length) {
                this.stream.append(string.charAt(i));
            } else {
                this.stream.append(c);
            }
            ++i;
        }
        this.lineCount += size;
    }

    public void addRight(String string, int size, char c) {
        int length = string.length();
        int i = 0;
        while (i < size) {
            if (i >= size - length) {
                this.stream.append(string.charAt(i - size + length));
            } else {
                this.stream.append(c);
            }
            ++i;
        }
        this.lineCount += size;
    }

    public int getLineCount() {
        return this.lineCount;
    }
}

