/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.system;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Powershell {
    private static final Powershell INSTANCE = new Powershell();
    private static final Pattern PS_CHARS = Pattern.compile("\\R+|'");

    public static final Powershell getInstance() {
        return INSTANCE;
    }

    private Powershell() {
    }

    public final String quote(String s) {
        StringBuffer sb = new StringBuffer((int)((double)s.length() * 1.1));
        this.quote(s, sb);
        return sb.toString();
    }

    public final void quote(String s, StringBuffer sb) {
        sb.append("'");
        Matcher m = PS_CHARS.matcher(s);
        while (m.find()) {
            String replacement = m.group().equals("'") ? "''" : "' + \"`n\" + '";
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        sb.append("'");
    }

    public final String quoteArray(List<String> l) {
        StringBuffer sb = new StringBuffer(l.size() * 64);
        sb.append("@(");
        Iterator<String> iter = l.iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            this.quote(s, sb);
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public final String getEncodedCommand(String s) {
        return Base64.getEncoder().encodeToString(s.getBytes(StandardCharsets.UTF_16LE));
    }
}

