/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.prog;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.cc.IClosure;

public class ModDate {
    private static final String FORMAT = "yyyyMMdd-HH:mm:ss";
    private static final DateFormat df = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");

    public static void main(String[] args) throws IOException, ParseException {
        if (args.length == 1 && args[0].equals("dump")) {
            ModDate.dump(new File("."), System.out);
        } else if (args.length == 3 && args[0].equals("load")) {
            Date beginDate = df.parse(args[1]);
            Date endDate = df.parse(args[2]);
            ModDate.load(new File("."), new InputStreamReader(System.in), beginDate, endDate);
        } else {
            ModDate.usage();
        }
    }

    private static void usage() {
        System.err.println("Usage: " + ModDate.class.getCanonicalName() + " [dump|load " + FORMAT + " " + FORMAT + "]");
        System.err.println("");
        System.err.println("This program can correct wrong modification date for files created by 'cp -R' without -p");
        System.err.println("1) dump from a valid backup to get correct dates");
        System.err.println("2) load to the copied tree indicating start and finish date of the copy ;");
        System.err.println("   the program makes sure that only files copied between those dates and whose size have not changed since, will be touched");
        System.err.println("");
        System.err.println("dump: Dumps on stdout for each file under current dir its relative path, its modification date and its length (0 for directories)");
        System.err.println("load: Read on stdin the relative path, modification date and length,");
        System.err.println("        and touch the file if its modification date is between the passed bounds and its size is the same");
        System.err.println("        otherwise it prints 'Ignoring: ' followed by the pb");
    }

    private static void dump(final File rootDir, final PrintStream out) {
        FileUtils.walk(rootDir, new IClosure<File>(){

            @Override
            public void executeChecked(File f) {
                try {
                    out.println(FileUtils.relative(rootDir, f));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                out.println(f.lastModified());
                if (f.isFile()) {
                    out.println(f.length());
                } else {
                    out.println(0);
                }
            }
        });
    }

    private static void load(File rootDir, Reader rr, Date beginDate, Date endDate) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(rr);
        while ((line = r.readLine()) != null) {
            String path = line;
            long modTime = Long.parseLong(r.readLine());
            long size = Long.parseLong(r.readLine());
            File f = new File(rootDir, path);
            if (!f.exists()) continue;
            String pb = ModDate.ok(f, beginDate, endDate, size);
            if (pb == null) {
                System.out.println(new Date(modTime) + " : " + f);
                f.setLastModified(modTime);
                continue;
            }
            System.out.println("Ignoring : " + f + pb);
        }
    }

    private static String ok(File f, Date beginDate, Date endDate, long size) {
        String res;
        String string = res = ModDate.between(f.lastModified(), beginDate, endDate) ? "" : " Pb date: not inbetween" + new Date(f.lastModified());
        if (f.isFile()) {
            res = String.valueOf(res) + (size == f.length() ? "" : "\nPb size: new " + f.length() + "!= old " + size);
        }
        return res.length() == 0 ? null : res;
    }

    private static final boolean between(long modif, Date beginDate, Date endDate) {
        return ModDate.compare(modif, '>', beginDate) && ModDate.compare(modif, '<', endDate);
    }

    private static final boolean compare(long modif, char way, Date date) {
        if (way != '<' && way != '>') {
            throw new IllegalArgumentException("< or > : " + way);
        }
        return date == null ? true : (way == '<' ? modif < date.getTime() : modif > date.getTime());
    }
}

