/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openconcerto.utils.IntHashSet;
import org.openconcerto.utils.cc.IdentitySet;

public final class LinkedIdentitySet<E>
extends AbstractSet<E>
implements IdentitySet<E>,
Cloneable {
    private final LinkedList<E> list = new LinkedList();
    private final IntHashSet identityHashCodes;

    public LinkedIdentitySet() {
        this.identityHashCodes = new IntHashSet();
    }

    public LinkedIdentitySet(int size) {
        this.identityHashCodes = new IntHashSet(size);
    }

    public LinkedIdentitySet(Collection<? extends E> c) {
        this.identityHashCodes = new IntHashSet(c.size());
        this.addAll(c);
    }

    public final List<E> getList() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public boolean add(E e) {
        if (this.contains(e)) {
            return false;
        }
        this.list.add(e);
        this.identityHashCodes.add(System.identityHashCode(e));
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return super.addAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
        this.identityHashCodes.clear();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean contains(Object o) {
        return this.identityHashCodes.contains(System.identityHashCode(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return super.containsAll(c);
    }

    @Override
    public boolean remove(Object o) {
        Iterator<E> e = this.iterator();
        while (e.hasNext()) {
            if (o != e.next()) continue;
            e.remove();
            this.identityHashCodes.remove(System.identityHashCode(o));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> i = this.iterator();
        while (i.hasNext()) {
            E obj = i.next();
            if (!c.contains(obj)) continue;
            i.remove();
            this.identityHashCodes.remove(System.identityHashCode(obj));
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public Object clone() {
        return new LinkedIdentitySet<E>(this);
    }
}

