/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.cache.CacheItem;
import org.openconcerto.utils.cc.IdentityHashSet;

public abstract class CacheWatcher<D> {
    @GuardedBy(value="this")
    private final Set<CacheItem<?, ?, ? extends D>> values = new IdentityHashSet();
    @GuardedBy(value="this")
    private final ListMap<Object, CacheItem<?, ?, ? extends D>> additionalToNotify = ListMap.decorate(new IdentityHashMap());
    private final D data;

    protected CacheWatcher(D data) {
        this.data = data;
    }

    public final D getData() {
        return this.data;
    }

    final synchronized boolean isEmpty() {
        return this.values.isEmpty();
    }

    final synchronized boolean add(CacheItem<?, ?, ? extends D> key) {
        assert (Thread.holdsLock(key) && key.getRemovalType() == null);
        boolean wasEmpty = this.isEmpty();
        boolean added = this.values.add(key);
        if (added) {
            for (List l : this.additionalToNotify.values()) {
                l.add(key);
            }
            if (wasEmpty) {
                this.startWatching();
            }
        } else assert (!wasEmpty);
        assert (!this.isEmpty());
        return added;
    }

    final synchronized boolean remove(CacheItem<?, ?, ? extends D> key) {
        if (!this.isEmpty()) {
            for (List l : this.additionalToNotify.values()) {
                l.remove(key);
            }
            boolean res = this.values.remove(key);
            if (this.isEmpty()) {
                this.stopWatching();
            }
            return res;
        }
        return false;
    }

    protected void startWatching() {
    }

    protected void stopWatching() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void dataChanged(Object event) {
        CacheWatcher cacheWatcher;
        ArrayList vals;
        CacheWatcher cacheWatcher2 = this;
        synchronized (cacheWatcher2) {
            List prev = (List)this.additionalToNotify.putCollection(event, new ArrayList());
            assert (prev == null) : "Duplicate event : " + event;
            vals = new ArrayList(this.values);
        }
        try {
            this.fire(event, vals);
        }
        catch (Throwable throwable) {
            cacheWatcher = this;
            synchronized (cacheWatcher) {
                List remove = (List)this.additionalToNotify.remove(event);
                vals = remove == null ? Collections.emptyList() : new ArrayList(remove);
            }
            this.fire(event, vals);
            throw throwable;
        }
        cacheWatcher = this;
        synchronized (cacheWatcher) {
            List remove = (List)this.additionalToNotify.remove(event);
            vals = remove == null ? Collections.emptyList() : new ArrayList(remove);
        }
        this.fire(event, vals);
    }

    private void fire(Object event, Collection<CacheItem<?, ?, ? extends D>> vals) {
        assert (!Thread.holdsLock(this));
        for (CacheItem<?, ?, D> val : vals) {
            if (!this.changedBy(val, event)) continue;
            val.setRemovalType(CacheItem.RemovalType.DATA_CHANGE);
        }
    }

    protected boolean changedBy(CacheItem<?, ?, ? extends D> val, Object event) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String vals;
        CacheWatcher cacheWatcher = this;
        synchronized (cacheWatcher) {
            vals = String.valueOf(this.values);
        }
        return String.valueOf(this.getClass().getSimpleName()) + " on " + this.getData() + " : " + vals;
    }
}

