/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JFrame;

public class Screenshot {
    private static int untitledIndex = 0;

    public static void capture(JFrame f) throws IOException {
        Screenshot.captureToDir(f, new File("."));
    }

    public static void captureToDir(JFrame f, File dir) throws IOException {
        if (dir.exists() && !dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        if (!dir.isDirectory()) {
            dir.mkdir();
        }
        String title = f.getTitle().length() == 0 ? "untitled" + untitledIndex++ : f.getTitle().replace('/', '_');
        Screenshot.capture(f, new File(dir, String.valueOf(title) + ".png"));
    }

    public static void capture(JFrame f, File file) throws IOException {
        File dir;
        String ext = file.getName().substring(file.getName().lastIndexOf(46) + 1);
        ImageWriter iw = Screenshot.getImageWriter(ext);
        Rectangle rect = f.getBounds();
        BufferedImage screenShot = new BufferedImage(rect.width, rect.height, 1);
        Graphics2D graphics2D = screenShot.createGraphics();
        boolean isShowing = f.isShowing();
        if (!isShowing) {
            f.show();
        }
        f.printAll(graphics2D);
        if (!isShowing) {
            f.hide();
        }
        if ((dir = file.getParentFile()) != null && !dir.isDirectory()) {
            dir.mkdir();
        }
        FileImageOutputStream out = new FileImageOutputStream(file);
        iw.setOutput(out);
        ImageWriteParam param = iw.getDefaultWriteParam();
        if (param.canWriteCompressed()) {
            param.setCompressionMode(2);
            param.setCompressionQuality(0.9f);
        }
        iw.write(null, new IIOImage(screenShot, null, null), param);
        out.close();
    }

    private static ImageWriter getImageWriter(String ext) throws IOException {
        ImageWriterSpi iwSpi = null;
        Iterator<ImageWriterSpi> iter = IIORegistry.getDefaultInstance().getServiceProviders(ImageWriterSpi.class, false);
        while (iter.hasNext()) {
            ImageWriterSpi c = iter.next();
            if (!Arrays.asList(c.getFileSuffixes()).contains(ext)) continue;
            iwSpi = c;
        }
        if (iwSpi == null) {
            throw new IllegalStateException("No providers for " + ext);
        }
        return iwSpi.createWriterInstance();
    }
}

