/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.TableSearchParameterType;
import org.openconcerto.utils.io.Transferable;

public class TableSearchParameter
implements Transferable {
    private String id;
    private String label;
    private List<TableSearchParameterType> types = new ArrayList<TableSearchParameterType>();

    public TableSearchParameter() {
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public List<TableSearchParameterType> getTypes() {
        return this.types;
    }

    public TableSearchParameter(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public void add(TableSearchParameterType type) {
        this.types.add(type);
    }

    public void remove(TableSearchParameterType type) {
        this.types.remove(type);
    }

    @Override
    public JSONObject toJSON() {
        if (this.id == null) {
            throw new IllegalStateException("null id");
        }
        if (this.label == null) {
            throw new IllegalStateException("null label");
        }
        JSONObject obj = new JSONObject();
        obj.put("id", this.id);
        obj.put("label", this.label);
        if (!this.types.isEmpty()) {
            JSONArray array = new JSONArray();
            for (TableSearchParameterType type : this.types) {
                array.add(type.toJSON());
            }
            obj.put("types", array);
        }
        return obj;
    }

    @Override
    public void fromJSON(JSONObject json) {
        this.id = json.getAsString("id");
        this.label = json.getAsString("label");
        if (this.id == null) {
            throw new IllegalStateException("null id");
        }
        if (this.label == null) {
            throw new IllegalStateException("null label");
        }
        this.types.clear();
        if (json.containsKey("types")) {
            JSONArray array = (JSONArray)json.get("types");
            for (Object object : array) {
                TableSearchParameterType t = new TableSearchParameterType();
                t.fromJSON((JSONObject)object);
                this.types.add(t);
            }
        }
    }
}

