/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component.combo;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.ui.component.combo.ISearchableComboItem;
import org.openconcerto.ui.component.combo.SearchMode;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.model.IListModel;
import org.openconcerto.utils.model.ISearchable;

public class ISearchableComboCompletionThread<T>
extends SwingWorker<List<ISearchableComboItem<T>>, Object> {
    private final ISearchableCombo<T> combo;
    private final IListModel<T> sourceModel;
    private final List<ISearchableComboItem<T>> toProcess;
    private final String t;
    private final int maxResults;

    public ISearchableComboCompletionThread(ISearchableCombo<T> combo, String t) {
        this.combo = combo;
        this.sourceModel = combo.getCache();
        this.toProcess = this.getModelValues();
        this.t = t;
        this.maxResults = this.getCombo().getMaximumResult();
    }

    private ISearchableCombo<T> getCombo() {
        return this.combo;
    }

    private final List<ISearchableComboItem<T>> getModelValues() {
        assert (SwingUtilities.isEventDispatchThread());
        return new ArrayList<ISearchableComboItem<T>>(this.getCombo().getModelValues());
    }

    private final boolean isShowAll() {
        return this.t == null;
    }

    private synchronized boolean isStopped() {
        return Thread.currentThread().isInterrupted();
    }

    @Override
    protected List<ISearchableComboItem<T>> doInBackground() throws Exception {
        List<ISearchableComboItem<T>> l = !this.isShowAll() ? this.getMatchingValues() : this.getMaxValues();
        return l;
    }

    @Override
    protected void done() {
        block4: {
            super.done();
            try {
                this.getCombo().setMatchingCompletions((List)this.get(), this.isShowAll());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (CancellationException e) {
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RTInterruptedException) break block4;
                e.printStackTrace();
            }
        }
    }

    private List<ISearchableComboItem<T>> getMaxValues() {
        List<ISearchableComboItem<T>> allVals = this.toProcess;
        return allVals.subList(0, Math.min(this.maxResults, allVals.size()));
    }

    private List<ISearchableComboItem<T>> getMatchingValues() {
        ISearchable searchableListModel;
        ArrayList<ISearchableComboItem<T>> result = new ArrayList<ISearchableComboItem<T>>();
        int minimumSearch = this.getCombo().getMinimumSearch();
        String aText = this.t.trim();
        String normalizedText = aText.length() < minimumSearch ? "" : aText;
        Boolean searched = null;
        List cache = this.toProcess;
        if (this.sourceModel instanceof ISearchable && (searchableListModel = (ISearchable)((Object)this.sourceModel)).isSearchable()) {
            FutureTask searchedValues = new FutureTask(new Callable<List<ISearchableComboItem<T>>>(){

                @Override
                public List<ISearchableComboItem<T>> call() throws Exception {
                    return ISearchableComboCompletionThread.this.getModelValues();
                }
            });
            searched = searchableListModel.setSearch(normalizedText, searchedValues);
            try {
                cache = (List)searchedValues.get();
            }
            catch (InterruptedException e) {
                throw new RTInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("No op couldn't be executed", e);
            }
        }
        if (!normalizedText.isEmpty() && searched != Boolean.FALSE) {
            SearchMode.ComboMatcher search = Boolean.TRUE.equals(searched) ? null : this.getCombo().getCompletionMode().matcher(normalizedText.toLowerCase());
            int maximumResult = this.maxResults;
            int index = 0;
            while (index < cache.size()) {
                ISearchableComboItem itemO = (ISearchableComboItem)cache.get(index);
                String item = itemO.asString();
                if (index % 50 == 0 && this.isStopped()) {
                    return result;
                }
                boolean ok = search == null || search.match(item.toLowerCase());
                boolean removeDuplicate = true;
                if (ok) {
                    int i = 0;
                    while (i < result.size()) {
                        if (this.isStopped()) {
                            return result;
                        }
                        ISearchableComboItem element = (ISearchableComboItem)result.get(i);
                        if (element.asString().equalsIgnoreCase(item)) {
                            ok = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (ok) {
                    result.add(itemO);
                }
                if (result.size() > maximumResult) break;
                ++index;
            }
        }
        return result;
    }

    static final List<String> cut(String value) {
        ArrayList<String> v = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(value);
        while (tokenizer.hasMoreElements()) {
            String element = (String)tokenizer.nextElement();
            v.add(element);
        }
        return v;
    }
}

