/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JComponent;
import org.openconcerto.ui.RoundedMenuItem;

public class RoundedComponentMenu
extends JComponent {
    private String name;
    private Vector items = new Vector();
    private Color bgColor = new Color(174, 4, 21);
    private Color fgColor = Color.white;

    public RoundedComponentMenu(String name) {
        this.name = name;
    }

    public void addMenuItem(RoundedMenuItem m) {
        this.items.add(m);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = new Dimension(600, 100 * this.items.size());
        return d;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.bgColor);
        int h = this.getHeight();
        int w = this.getWidth();
        g.fillRect(0, 0, w, h);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.fgColor);
        int m = (int)(1.8 * (double)h);
        g.fillOval(100, -m / 3, m, m);
        g.setColor(Color.BLACK);
        int fontSize = 48;
        Font font = new Font("Arial", 1, fontSize);
        g.setFont(font);
        g.drawString(this.name, 50, 30 + fontSize);
        int d = 60;
        int k = 0;
        int y = 0;
        while (y < 80 * this.items.size()) {
            float xx = (float)(m * m) - 4.0f * (float)y * (float)y;
            float x = -((int)(Math.sqrt(xx) / 2.0));
            System.out.println("xx:" + xx + "x" + x + "y:" + y);
            g.setColor(Color.WHITE);
            g.fillOval((int)x + m / 2 + 100 - d * 3 / 5, y + m / 6 - d / 2, d, d);
            g.setColor(Color.BLACK);
            g.drawOval((int)x + m / 2 + 100 - d * 3 / 5, y + m / 6 - d / 2, d, d);
            g.setColor(Color.lightGray);
            String label = "Sous memu";
            Rectangle2D rect = font.getStringBounds(label, ((Graphics2D)g).getFontRenderContext());
            g.drawString(((RoundedMenuItem)this.items.elementAt(k)).getName(), (int)(x + (float)(m / 2) + 160.0f), (int)((double)(y + m / 6 - d / 2) + rect.getHeight() / 2.0));
            ++k;
            y += 80;
        }
    }
}

