/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.openconcerto.sql.view.list.action.ListEvent;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.i18n.TranslationManager;

public abstract class SQLRowValuesAction {
    private final Consumer<? super ListEvent> action;
    private final boolean header;
    private final boolean popupMenu;
    private List<String> path;
    private final String id;
    private String name;

    public SQLRowValuesAction(boolean header, Consumer<? super ListEvent> action) {
        this(header, true, action);
    }

    public SQLRowValuesAction(boolean header, boolean popupMenu, Consumer<? super ListEvent> action) {
        this(header, popupMenu, null, action);
    }

    public SQLRowValuesAction(boolean header, String id, Consumer<? super ListEvent> action) {
        this(header, true, id, action);
    }

    public SQLRowValuesAction(boolean header, boolean popupMenu, String id, Consumer<? super ListEvent> action) {
        this.action = action;
        this.header = header;
        this.popupMenu = popupMenu;
        this.setGroup(null);
        this.id = id;
        if (id != null) {
            this.setName(TranslationManager.getInstance().getTranslationForAction(id));
        }
    }

    public final String getID() {
        return this.id;
    }

    public final SQLRowValuesAction setName(String name) {
        this.name = name;
        return this;
    }

    public final String getName() {
        return this.name;
    }

    public final Consumer<? super ListEvent> getAction() {
        return this.action;
    }

    public final boolean inHeader() {
        return this.header;
    }

    public final boolean inPopupMenu() {
        return this.popupMenu;
    }

    public final SQLRowValuesAction setGroup(String groupName) {
        this.path = Arrays.asList(groupName);
        return this;
    }

    public final SQLRowValuesAction setPath(List<String> path) {
        this.path = Collections.unmodifiableList(new ArrayList<String>(path));
        return this;
    }

    public final List<String> getPath() {
        return this.path;
    }

    public abstract boolean enabledFor(ListEvent var1);

    public Consumer<? super ListEvent> getDefaultAction(ListEvent evt) {
        return this.enabledFor(evt) ? this.getAction() : null;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + (this.getID() == null ? "" : " ID '" + this.getID()) + "'";
    }

    public static class PredicateRowAction
    extends SQLRowValuesAction {
        private IPredicate<? super ListEvent> pred = null;

        public PredicateRowAction(boolean header, Consumer<? super ListEvent> action) {
            super(header, action);
        }

        public PredicateRowAction(boolean header, boolean popupMenu, Consumer<? super ListEvent> action) {
            super(header, popupMenu, action);
        }

        public PredicateRowAction(boolean header, String id, Consumer<? super ListEvent> action) {
            super(header, id, action);
        }

        public PredicateRowAction(boolean header, boolean popupMenu, String id, Consumer<? super ListEvent> action) {
            super(header, popupMenu, id, action);
        }

        public final PredicateRowAction setPredicate(IPredicate<? super ListEvent> pred) {
            if (pred == null) {
                throw new IllegalArgumentException("null predicate");
            }
            this.pred = pred;
            return this;
        }

        public final IPredicate<? super ListEvent> getPredicate() {
            return this.pred;
        }

        @Override
        public boolean enabledFor(ListEvent evt) {
            if (this.pred == null) {
                throw new IllegalStateException("No predicate for " + this);
            }
            return this.pred.evaluateChecked(evt);
        }
    }
}

