/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.function.Function;
import javax.swing.JFrame;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.State;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.state.WindowStateManager;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StringUtils;

public class IListFrame
extends JFrame {
    public static final String SHORT_TITLE = "org.openconcerto.listframe.shortTitle";
    private static final String FILE_STRUCT_VERSION = "20160923";
    private static Function<? super SQLElement, File> CONF_DIR_FUNCTION = elem -> {
        Configuration conf = Configuration.getInstance();
        return conf == null ? null : conf.getConfDir();
    };
    private final IListPanel panel;
    private String title;

    public static final synchronized void setConfDirFunction(Function<? super SQLElement, File> f) {
        CONF_DIR_FUNCTION = f;
    }

    public static final synchronized File getConfDir(SQLElement elem) {
        if (CONF_DIR_FUNCTION == null) {
            return null;
        }
        return CONF_DIR_FUNCTION.apply(elem);
    }

    public static final File getConfigFile(SQLElement elem, Class<? extends JFrame> c) {
        return IListFrame.getConfigFile(elem, null, c);
    }

    public static final File getConfigFile(SQLComponent comp, Class<? extends JFrame> c) {
        return IListFrame.getConfigFile(comp.getElement(), comp, c);
    }

    private static final File getConfigFile(SQLElement elem, SQLComponent comp, Class<? extends Window> c) {
        String compName = comp == null ? "" : "-" + comp.getCode();
        return IListFrame.getConfigFile(IListFrame.getConfDir(elem), c, String.valueOf(elem.getCode()) + compName);
    }

    public static final File getConfigFile(Class<? extends Window> c, String code) {
        return IListFrame.getConfigFile(IListFrame.getConfDir(null), c, code);
    }

    public static final File getConfigFile(File rootDir, Class<? extends Window> c, String code) {
        if (rootDir == null) {
            return null;
        }
        File structFile = new File(rootDir, "windowState-20160923");
        return new File(structFile, String.valueOf(c.getSimpleName()) + File.separator + IListFrame.getConfigFileName(code));
    }

    static final String getConfigFileName(String code) {
        if (StringUtils.isEmpty(code, true)) {
            code = "default";
        }
        return String.valueOf(StringUtils.Shortener.MD5.getBoundedLengthString(FileUtils.FILENAME_ESCAPER.escape(code), 70)) + ".xml";
    }

    public IListFrame(IListPanel panel) {
        this.panel = panel;
        this.title = null;
        this.panel.getListe().addListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                IListFrame.this.setTitle();
            }
        });
        this.getPanel().getListe().addListenerOnModel(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == null || evt.getPropertyName().equals("loading") || evt.getPropertyName().equals("searching")) {
                    IListFrame.this.setTitle();
                }
            }
        });
        this.uiInit();
        State.INSTANCE.frameCreated();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                State.INSTANCE.frameHidden();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                State.INSTANCE.frameShown();
            }
        });
    }

    protected String getPlural(String s, int nb) {
        return String.valueOf(nb) + " " + s + (nb > 1 ? "s" : "");
    }

    protected void setTitle(boolean displayRowCount, boolean displayItemCount) {
        String title;
        if (this.title == null) {
            String prefix = Boolean.getBoolean(SHORT_TITLE) ? "" : "Liste des ";
            title = String.valueOf(prefix) + this.panel.getElement().getPluralName();
        } else {
            title = this.title;
        }
        if (this.panel.getListe().isDead()) {
            title = String.valueOf(title) + ", d\u00e9truite";
        } else {
            ITableModel model;
            int count;
            if (displayRowCount) {
                int rowCount = this.panel.getListe().getRowCount();
                title = String.valueOf(title) + ", " + this.getPlural("ligne", rowCount);
                int total = this.panel.getListe().getTotalRowCount();
                if (total != rowCount) {
                    title = String.valueOf(title) + " / " + total;
                }
            }
            if (displayItemCount && (count = this.panel.getListe().getItemCount()) >= 0) {
                title = String.valueOf(title) + ", " + this.getPlural("\u00e9l\u00e9ment", count);
            }
            if ((model = this.getPanel().getListe().getModel()).isLoading()) {
                title = String.valueOf(title) + ", chargement en cours";
            }
            if (model.isSearching()) {
                title = String.valueOf(title) + ", recherche en cours";
            }
        }
        this.setTitle(title);
    }

    public void setTextTitle(String s) {
        this.title = s;
    }

    public void setTitle() {
        this.setTitle(true, true);
    }

    private final void uiInit() {
        this.setTitle();
        this.getContentPane().setLayout(new GridLayout());
        this.getContentPane().add(this.panel);
        FrameUtil.setBounds(this);
        File file = this.getPanel().getSQLComponent() != null ? IListFrame.getConfigFile(this.getPanel().getSQLComponent(), this.getClass()) : IListFrame.getConfigFile(this.getPanel().getElement(), this.getClass());
        if (file != null) {
            new WindowStateManager(this, file).loadState();
        }
    }

    public final IListPanel getPanel() {
        return this.panel;
    }
}

