/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.Constraint;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public final class AlterTable
extends ChangeTable<AlterTable> {
    private final SQLTable t;

    public AlterTable(SQLTable t) {
        super(t.getDBSystemRoot().getSyntax(), t.getDBRoot().getName(), t.getName());
        this.t = t;
    }

    AlterTable(SQLSyntax s, String rootName, String tableName) {
        super(s, rootName, tableName);
        this.t = null;
    }

    public final SQLTable getTable() {
        return this.t;
    }

    @Override
    protected String getConstraintPrefix() {
        return "ADD ";
    }

    @Override
    public final AlterTable addColumn(String name, String definition) {
        return (AlterTable)this.addClause("ADD " + SQLBase.quoteIdentifier(name) + " " + definition, ChangeTable.ClauseType.ADD_COL);
    }

    public final AlterTable addPrimaryKey(List<String> names) {
        if (names.size() == 0) {
            throw new IllegalArgumentException("Empty fields");
        }
        return (AlterTable)this.addClause("ADD PRIMARY KEY(" + SQLSyntax.quoteIdentifiers(names) + ")", ChangeTable.ClauseType.ADD_CONSTRAINT);
    }

    public final AlterTable dropColumn(String name) {
        if (this.getSyntax().getSystem() == SQLSystem.MSSQL) {
            this.alterColumnDefault(name, null);
        }
        return (AlterTable)this.addClause("DROP COLUMN " + SQLBase.quoteIdentifier(name), ChangeTable.ClauseType.DROP_COL);
    }

    public final AlterTable dropColumnCascade(String name) {
        return this.dropColumnsCascade(Collections.singleton(name));
    }

    public final AlterTable dropColumnsCascade(Collection<String> columns) {
        for (Link l : this.t.getForeignLinks()) {
            if (!CollectionUtils.containsAny(l.getCols(), columns)) continue;
            this.dropForeignConstraint(l.getName());
        }
        for (Constraint c : this.t.getConstraints()) {
            if (!CollectionUtils.containsAny(c.getCols(), columns)) continue;
            this.dropConstraint(c.getName());
        }
        for (String name : columns) {
            this.dropColumn(name);
        }
        return (AlterTable)this.thisAsT();
    }

    public final AlterTable dropForeignColumn(String name) {
        return this.dropForeignColumns(Collections.singletonList(name));
    }

    public final AlterTable dropForeignColumns(List<String> columns) throws IllegalArgumentException {
        Link foreignLink = this.t.getDBSystemRoot().getGraph().getForeignLink(this.t, columns);
        if (foreignLink == null) {
            throw new IllegalArgumentException("No foreign key in " + this.t + " with : " + columns);
        }
        return this.dropForeignColumns(foreignLink);
    }

    public final AlterTable dropForeignColumns(Link foreignLink) throws IllegalArgumentException {
        if (foreignLink.getSource() != this.t) {
            throw new IllegalArgumentException("Not in " + this.t + " : " + foreignLink);
        }
        this.dropForeignConstraint(foreignLink.getName());
        for (String name : foreignLink.getCols()) {
            this.dropColumn(name);
        }
        return (AlterTable)this.thisAsT();
    }

    public final AlterTable alterColumn(String fname, SQLField from) {
        return this.alterColumn(fname, from, EnumSet.allOf(SQLField.Properties.class));
    }

    public final AlterTable alterColumn(String fname, SQLField from, Set<SQLField.Properties> toTake) {
        return this.addClauses(this.getSyntax().getAlterField(this.t.getField(fname), from, toTake));
    }

    private final AlterTable addClauses(Map<ChangeTable.ClauseType, List<String>> res) {
        for (Map.Entry<ChangeTable.ClauseType, List<String>> e : res.entrySet()) {
            ChangeTable.ClauseType type = e.getKey();
            for (String s : e.getValue()) {
                this.addClause(s, type);
            }
        }
        return (AlterTable)this.thisAsT();
    }

    public final AlterTable alterColumn(String fname, Set<SQLField.Properties> toAlter, String type, String defaultVal, Boolean nullable) {
        return this.addClauses(this.getSyntax().getAlterField(this.t.getField(fname), toAlter, type, defaultVal, nullable));
    }

    public final AlterTable alterColumnNullable(String f, boolean b) {
        return this.alterColumn(f, EnumSet.of(SQLField.Properties.NULLABLE), null, null, b);
    }

    public final AlterTable alterColumnDefault(String f, String defaultVal) {
        return this.alterColumn(f, EnumSet.of(SQLField.Properties.DEFAULT), null, defaultVal, null);
    }

    public final AlterTable dropPrimaryKey() {
        return (AlterTable)this.addClause(this.getSyntax().getDropPrimaryKey(this.t), ChangeTable.ClauseType.DROP_CONSTRAINT);
    }

    public final AlterTable dropForeignConstraint(String name) {
        return (AlterTable)this.addClause(String.valueOf(this.getSyntax().getDropFK()) + SQLBase.quoteIdentifier(name), ChangeTable.ClauseType.DROP_CONSTRAINT);
    }

    public final AlterTable dropConstraint(String name) {
        return (AlterTable)this.addClause(String.valueOf(this.getSyntax().getDropConstraint()) + SQLBase.quoteIdentifier(name), ChangeTable.ClauseType.DROP_CONSTRAINT);
    }

    public final AlterTable dropIndex(String name) {
        return this.dropIndex(name, true);
    }

    private final AlterTable dropIndex(final String name, final boolean exact) {
        return (AlterTable)this.addOutsideClause(new ChangeTable.DeferredClause(){

            @Override
            public ChangeTable.ClauseType getType() {
                return ChangeTable.ClauseType.DROP_INDEX;
            }

            @Override
            public String asString(ChangeTable<?> ct, SQLName tableName) {
                return ct.getSyntax().getDropIndex(exact ? name : AlterTable.getIndexName(tableName, name), tableName);
            }
        });
    }

    public final AlterTable dropUniqueConstraint(final String name, boolean partial) {
        SQLSystem system = this.getSyntax().getSystem();
        if (system == SQLSystem.MSSQL) {
            return this.dropIndex(name, false);
        }
        if (!partial) {
            return (AlterTable)this.addClause(new ChangeTable.DeferredClause(){

                @Override
                public String asString(ChangeTable<?> ct, SQLName tableName) {
                    return String.valueOf(AlterTable.this.getSyntax().getDropConstraint()) + AlterTable.getQuotedConstraintName(tableName, name);
                }

                @Override
                public ChangeTable.ClauseType getType() {
                    return ChangeTable.ClauseType.DROP_CONSTRAINT;
                }
            });
        }
        if (system == SQLSystem.POSTGRESQL) {
            return this.dropIndex(name, false);
        }
        if (system == SQLSystem.H2) {
            return (AlterTable)this.addOutsideClause(new ChangeTable.DropUniqueTrigger(name));
        }
        if (system == SQLSystem.MYSQL) {
            String[] stringArray = TRIGGER_EVENTS;
            int n = TRIGGER_EVENTS.length;
            int n2 = 0;
            while (n2 < n) {
                String event = stringArray[n2];
                this.addOutsideClause(new ChangeTable.DropUniqueTrigger(name, event));
                ++n2;
            }
            return (AlterTable)this.thisAsT();
        }
        throw new UnsupportedOperationException("System isn't supported : " + (Object)((Object)system));
    }

    @Override
    protected String asString(ChangeTable.NameTransformer transf, ChangeTable.ConcatStep step) {
        return this.asString(transf, step.getTypes());
    }

    @Override
    public String asString(ChangeTable.NameTransformer transf) {
        return this.asString(transf, ChangeTable.ORDERED_TYPES);
    }

    private List<Tuple2<Boolean, List<String>>> getAllClauses(ChangeTable.InAndOutClauses allClauses, ChangeTable.NameTransformer transf, Set<ChangeTable.ClauseType> types, SQLName tableName) {
        ArrayList clauses = new ArrayList();
        Boolean lastIsStandalone = null;
        for (ChangeTable.ClauseType type : ORDERED_TYPES) {
            if (!types.contains((Object)type)) continue;
            ArrayList<Tuple2<Boolean, String>> inClauses = new ArrayList<Tuple2<Boolean, String>>();
            for (String inClause : allClauses.getInClauses().getClauses(this, tableName, transf, Collections.singleton(type))) {
                inClauses.add(Tuple2.create(false, inClause));
            }
            ArrayList<Tuple2<Boolean, String>> outClauses = new ArrayList<Tuple2<Boolean, String>>();
            for (String inClause : allClauses.getOutClauses().getClauses(this, tableName, transf, Collections.singleton(type))) {
                outClauses.add(Tuple2.create(true, inClause));
            }
            if (Boolean.TRUE.equals(lastIsStandalone)) {
                clauses.addAll(outClauses);
                clauses.addAll(inClauses);
            } else {
                clauses.addAll(inClauses);
                clauses.addAll(outClauses);
            }
            Boolean bl = lastIsStandalone = clauses.isEmpty() ? null : (Boolean)((Tuple2)clauses.get(clauses.size() - 1)).get0();
        }
        lastIsStandalone = null;
        ArrayList<Tuple2<Boolean, List<String>>> res = new ArrayList<Tuple2<Boolean, List<String>>>();
        for (Tuple2 clause : clauses) {
            Boolean currentIsStandAlone = (Boolean)clause.get0();
            assert (currentIsStandAlone != null);
            if (!currentIsStandAlone.equals(lastIsStandalone)) {
                res.add(Tuple2.create(currentIsStandAlone, new ArrayList()));
            }
            ((List)((Tuple2)res.get(res.size() - 1)).get1()).add((String)clause.get1());
            lastIsStandalone = currentIsStandAlone;
        }
        return res;
    }

    private final String asString(ChangeTable.NameTransformer transf, Set<ChangeTable.ClauseType> types) {
        return this.asString(this.getClauses(), transf, types);
    }

    protected final String asString(ChangeTable.InAndOutClauses allClauses, ChangeTable.NameTransformer transf, Set<ChangeTable.ClauseType> types) {
        SQLName tableName = transf.transformTableName(new SQLName(this.getRootName(), this.getName()));
        StringBuffer res = new StringBuffer(512);
        final String alterTable = "ALTER TABLE " + tableName.quote();
        for (Tuple2<Boolean, List<String>> standaloneAndClauses : this.getAllClauses(allClauses, transf, types, tableName)) {
            List<String> genClauses = standaloneAndClauses.get1();
            if (standaloneAndClauses.get0().booleanValue()) {
                res.append(CollectionUtils.join(genClauses, "\n"));
            } else if (this.getSyntax().supportMultiAlterClause()) {
                res.append(String.valueOf(alterTable) + " \n");
                res.append(CollectionUtils.join(genClauses, ",\n"));
                res.append(";");
            } else {
                res.append(CollectionUtils.join(genClauses, "\n", new ITransformer<String, String>(){

                    @Override
                    public String transformChecked(String input) {
                        return String.valueOf(alterTable) + " " + input + ";";
                    }
                }));
            }
            res.append('\n');
        }
        if (res.length() > 0) {
            res.setLength(res.length() - 1);
        }
        return res.toString();
    }
}

