/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.TransactionPoint;
import org.openconcerto.sql.request.SQLCacheWatcher;
import org.openconcerto.utils.cache.CacheWatcherFactory;
import org.openconcerto.utils.cache.ICache;
import org.openconcerto.utils.cache.ICacheSupport;

public class SQLCache<K, V>
extends ICache<K, V, SQLData> {
    private final TransactionPoint txPoint;
    private final List<TransactionPoint> releasedTxPoints;

    public SQLCache() {
        this(60);
    }

    public SQLCache(int delay) {
        this(delay, -1);
    }

    public SQLCache(int delay, int size) {
        this(delay, size, null);
    }

    public SQLCache(int delay, int size, String name) {
        this(null, delay, size, name, null);
    }

    public SQLCache(ICacheSupport<SQLData> supp, int delay, int size, String name, TransactionPoint txPoint) {
        super(supp, delay, size, name);
        this.txPoint = txPoint;
        this.releasedTxPoints = new ArrayList<TransactionPoint>();
    }

    @Override
    protected ICacheSupport<SQLData> createSupp(String name) {
        ICacheSupport<SQLData> res = super.createSupp(name);
        res.setWatcherFactory(new CacheWatcherFactory<SQLData>(){

            public SQLCacheWatcher createWatcher(SQLData o) {
                return new SQLCacheWatcher(o);
            }
        });
        return res;
    }

    public final TransactionPoint getTransactionPoint() {
        return this.txPoint;
    }

    private final void addReleasedSavePoint(TransactionPoint txPoint) {
        if (txPoint.getSavePoint() == null || txPoint.getState() != TransactionPoint.State.COMMITTED) {
            throw new IllegalArgumentException("Not a released savepoint : " + txPoint);
        }
        if (txPoint.getTransaction() != this.getTransactionPoint().getTransaction()) {
            throw new IllegalArgumentException("Not in same transaction : " + txPoint);
        }
        this.releasedTxPoints.add(txPoint);
    }

    public final void addReleasedSavePoints(SQLCache<K, V> cache) {
        if (this.getSupp() != cache.getSupp()) {
            throw new IllegalArgumentException("Not same support : " + cache);
        }
        for (TransactionPoint tp : cache.releasedTxPoints) {
            this.addReleasedSavePoint(tp);
        }
        this.addReleasedSavePoint(cache.getTransactionPoint());
    }

    public final boolean changedBy(TransactionPoint evtTxPoint) {
        assert (this.getTransactionPoint() != null) : "See SQLCacheWatcher";
        if (evtTxPoint.isActive()) {
            return this.getTransactionPoint() == evtTxPoint;
        }
        if (evtTxPoint.wasCommitted()) {
            return this.releasedTxPoints.contains(evtTxPoint);
        }
        return false;
    }
}

