/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import net.jcip.annotations.ThreadSafe;
import org.jgrapht.Graph;

@ThreadSafe
public class DirectedEdge<V> {
    private final V src;
    private final V dst;

    public DirectedEdge(V src, V dst) {
        this.src = src;
        this.dst = dst;
    }

    public final V getSource() {
        return this.src;
    }

    public final V getTarget() {
        return this.dst;
    }

    public final V oppositeVertex(V end) {
        if (end == this.getSource()) {
            return this.getTarget();
        }
        if (end == this.getTarget()) {
            return this.getSource();
        }
        throw new IllegalArgumentException(end + " is not an end of " + this);
    }

    public String toString() {
        return "<" + this.getSource() + " -> " + this.getTarget() + ">";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DirectedEdge o = (DirectedEdge)obj;
        return this.getSource().equals(o.getSource()) && this.getTarget().equals(o.getTarget());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getSource().hashCode();
        result = 31 * result + this.getTarget().hashCode();
        return result;
    }

    public static final <V, E extends DirectedEdge<V>> void addEdge(Graph<V, E> g, E e) {
        g.addEdge(e.getSource(), e.getTarget(), e);
    }
}

