/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.List;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.utils.CompareUtils;

public final class SQLElementLinkSetup {
    private final SQLElementLinksSetup globalSetup;
    private final Path path;
    private final String typeError;
    private SQLElementLink.LinkType type;
    private SQLElement.ReferenceAction action;
    private String name;

    SQLElementLinkSetup(SQLElementLinksSetup globalSetup, Path path, SQLElementLink.LinkType type, String typeError) {
        this.globalSetup = globalSetup;
        this.path = path;
        this.typeError = typeError;
        this.setType(type);
        this.name = null;
    }

    public final SQLElement getElem() {
        return this.globalSetup.getElem();
    }

    public final SQLElement getTargetElement() {
        return this.getElem().getElementLenient(this.getPath().getLast());
    }

    public final Path getPath() {
        return this.path;
    }

    public final SQLElementLink.LinkType getType() {
        return this.type;
    }

    public SQLElementLinkSetup ignore() {
        return this.setType(null);
    }

    public final boolean isIgnored() {
        return this.getType() == null;
    }

    public final SQLElementLinkSetup setType(SQLElementLink.LinkType type) {
        return this.setType(type, null);
    }

    public final SQLElementLinkSetup setType(SQLElementLink.LinkType type, SQLElement.ReferenceAction action) throws IllegalArgumentException {
        SQLElement targetElem = this.getTargetElement();
        if (type == null) {
            if (action != null) {
                throw new IllegalArgumentException("No action should be specified for ignored path : " + (Object)((Object)action));
            }
        } else {
            List<SQLElement.ReferenceAction> possibleActions = this.getElem().getPossibleActions(type, targetElem);
            if (action == null) {
                action = possibleActions.get(0);
            } else if (!possibleActions.contains((Object)action)) {
                throw new IllegalArgumentException((Object)((Object)action) + " isn't allowed for " + this);
            }
        }
        if (!CompareUtils.equals((Object)this.type, (Object)type)) {
            if (this.type != null && this.typeError != null) {
                throw new IllegalArgumentException("Cannot change " + this + " : " + this.typeError);
            }
            if (type == null) {
                if (targetElem != null) {
                    throw new IllegalArgumentException("Cannot ignore " + this + " to existing element " + targetElem);
                }
            } else if (type == SQLElementLink.LinkType.PARENT) {
                if (this.globalSetup.getParent() != null) {
                    throw new IllegalArgumentException("Parent already set to " + this.globalSetup.getParent() + ". First set it to another type.");
                }
                if (targetElem.isPrivate()) {
                    throw new IllegalArgumentException("Cannot use " + this + " for parent, target element is private : " + targetElem);
                }
            } else if (type == SQLElementLink.LinkType.COMPOSITION) {
                if (!targetElem.isPrivate()) {
                    throw new IllegalArgumentException("Target element for " + this + " isn't private : " + targetElem);
                }
            } else assert (type == SQLElementLink.LinkType.ASSOCIATION);
            boolean removingParent = this.type == SQLElementLink.LinkType.PARENT;
            boolean settingParent = type == SQLElementLink.LinkType.PARENT;
            this.type = type;
            if (removingParent) {
                this.globalSetup.setParent(null);
            } else if (settingParent) {
                this.globalSetup.setParent(this.getPath());
            }
        }
        this.action = action;
        return this;
    }

    public final SQLElement.ReferenceAction getAction() {
        return this.action;
    }

    public final String getName() {
        return this.name;
    }

    public final SQLElementLinkSetup setName(String name) {
        this.name = name;
        return this;
    }

    final SQLElementLink build() {
        return new SQLElementLink(this.getElem(), this.getPath(), this.getTargetElement(), this.getType(), this.getName(), this.getAction());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.build();
    }
}

