/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.BaseSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLForeignRowItemView;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.checks.EmptyChangeSupport;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.ValidChangeSupport;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public abstract class ElementSQLObject
extends BaseSQLObject
implements SQLForeignRowItemView {
    private boolean required;
    private boolean createdUIVisible = true;
    private final SQLComponent parent;
    private final SQLComponent comp;
    private Boolean created;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private final ValidChangeSupport validSupp = new ValidChangeSupport(this);
    private EmptyChangeSupport helper = new EmptyChangeSupport(this);

    public ElementSQLObject(SQLComponent parent, SQLComponent comp) {
        this.parent = parent;
        this.comp = comp;
        this.required = false;
        this.comp.setOpaque(false);
        this.comp.setSQLParent(this);
        this.comp.setNonExistantEditable(true);
        this.comp.addValidListener(new ValidListener(){

            @Override
            public void validChange(ValidObject src, ValidState newValue) {
                if (ElementSQLObject.this.isCreated()) {
                    ElementSQLObject.this.supp.firePropertyChange("value", null, null);
                }
                ElementSQLObject.this.fireValidChange();
            }
        });
        if (parent.getMode() == SQLComponent.Mode.READ_ONLY) {
            this.getSQLChild().setMode(SQLComponent.Mode.READ_ONLY);
        } else {
            ((BaseSQLComponent)this.comp).addSelectionListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ElementSQLObject.this.getSQLChild().setMode(ElementSQLObject.this.getSQLChild().getSelectedID() < 0 ? SQLComponent.Mode.INSERTION : SQLComponent.Mode.MODIFICATION);
                }
            });
        }
        this.addValidListener(new ValidListener(){

            @Override
            public void validChange(ValidObject src, ValidState newValue) {
                ElementSQLObject.this.compChanged();
            }
        });
        this.uiInit();
        this.created = null;
        this.setCreated(false);
    }

    public final void setRequired(boolean required) {
        this.required = required;
        if (this.required) {
            this.setCreated(true);
        }
        this.uiChanged();
    }

    protected final boolean deleteAllowed() {
        return !this.required;
    }

    public final void setCreatedUIVisible(boolean b) {
        this.createdUIVisible = b;
        this.uiChanged();
    }

    public final boolean isCreatedUIVisible() {
        return this.createdUIVisible;
    }

    protected void uiChanged() {
    }

    protected abstract void uiInit();

    protected abstract void setCreatePanel();

    protected abstract void setEditPanel();

    protected void compChanged() {
    }

    public final void setCreated(boolean b) {
        if (!Boolean.valueOf(b).equals(this.created)) {
            this.created = b;
            if (this.created.booleanValue()) {
                this.setEditPanel();
            } else {
                this.setCreatePanel();
            }
            this.helper.fireEmptyChange(this.isEmpty());
            this.fireValidChange();
            this.supp.firePropertyChange("value", null, null);
        }
    }

    public final boolean isCreated() {
        return this.created;
    }

    @Override
    public void setValue(SQLRowAccessor r) {
        boolean displayableRow;
        boolean bl = displayableRow = r != null && !r.isUndefined();
        if (displayableRow) {
            this.setCreated(true);
            this.setCurrentID(r);
        } else {
            this.setCreated(!this.deleteAllowed());
            this.setCurrentID(null);
        }
        this.compChanged();
    }

    private void detach() {
        this.comp.detach();
        this.compChanged();
    }

    protected final void setCurrentID(SQLRowAccessor r) {
        this.comp.select(r);
    }

    private final void setCurrentID(int currentID) {
        if (currentID == -1) {
            this.comp.select(null);
        } else {
            this.comp.select(currentID);
        }
    }

    protected final int getCurrentID() {
        return this.comp.getSelectedID();
    }

    @Override
    public final int getSelectedId() {
        return this.getCurrentID();
    }

    @Override
    public void resetValue() {
        this.setValue(null);
    }

    @Override
    public boolean isEmpty() {
        return !this.isCreated();
    }

    @Override
    public void addEmptyListener(EmptyListener l) {
        this.helper.addEmptyListener(l);
    }

    @Override
    public void removeEmptyListener(EmptyListener l) {
        this.helper.removeEmptyListener(l);
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    @Override
    public final void removeValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public final SQLComponent getSQLParent() {
        return this.parent;
    }

    public final SQLComponent getSQLChild() {
        return this.comp;
    }

    @Override
    public String toString() {
        return "ElementSQLObject on " + this.getFields() + " created: " + this.isCreated() + " id: " + this.getCurrentID();
    }

    public void update() {
        if (this.isCreated()) {
            if (this.getCurrentID() == -1) {
                this.setCurrentID(this.comp.insert());
            } else {
                this.comp.update();
            }
        } else if (this.getCurrentID() != -1) {
            this.comp.archive();
            this.setCurrentID(-1);
        }
    }

    public void insert() {
        if (this.isCreated()) {
            this.setCurrentID(this.comp.insert());
        }
    }

    @Override
    public ValidState getValidState() {
        ValidState res = this.isCreated() ? this.getSQLChild().getValidState() : ValidState.getTrueInstance();
        return res;
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.validSupp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.validSupp.removeValidListener(l);
    }

    private void fireValidChange() {
        this.validSupp.fireValidChange(this.getValidState());
    }

    @Override
    public void setEditable(InteractionMode mode) {
        this.comp.setEditable(mode);
    }

    @Override
    public void insert(SQLRowValues vals) {
        this.insert();
        this.fillRowValues(vals);
        if (this.comp.getElement().dontDeepCopy()) {
            this.resetValue();
        } else {
            this.detach();
        }
    }

    @Override
    public void update(SQLRowValues vals) {
        this.update();
        this.fillRowValues(vals);
    }

    private void fillRowValues(SQLRowValues vals) {
        vals.put(this.getField().getName(), this.getCurrentID() == -1 ? SQLRowValues.SQL_EMPTY_LINK : Integer.valueOf(this.getCurrentID()));
    }

    @Override
    public void show(SQLRowAccessor r) {
        if (r.getFields().contains(this.getField().getName())) {
            this.setValue(r.getForeign(this.getField().getName()));
        }
    }

    @Override
    public Component getComp() {
        return this;
    }

    public SQLTable getForeignTable() {
        if (this.getField() == null) {
            throw new IllegalStateException(this + " not initialized.");
        }
        return this.getTable().getBase().getGraph().getForeignTable(this.getField());
    }
}

