/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.correct;

import java.sql.SQLException;
import java.util.EnumSet;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.cc.ITransformer;

public class FixSharedPrivate
extends Changer<SQLTable> {
    private final SQLElementDirectory dir;

    public FixSharedPrivate(DBSystemRoot b) {
        this(b, null);
    }

    public FixSharedPrivate(DBSystemRoot b, SQLElementDirectory dir) {
        super(b);
        if (dir == null) {
            if (Configuration.getInstance() == null) {
                throw new IllegalStateException("no conf");
            }
            this.dir = Configuration.getInstance().getDirectory();
            if (this.dir == null) {
                throw new IllegalStateException("no directory in conf");
            }
        } else {
            this.dir = dir;
        }
        assert (this.dir != null);
    }

    public final SQLElementDirectory getDir() {
        return this.dir;
    }

    @Override
    protected EnumSet<SQLSystem> getCompatibleSystems() {
        return EnumSet.complementOf(EnumSet.of(SQLSystem.MYSQL));
    }

    @Override
    protected void changeImpl(final SQLTable t) throws SQLException {
        this.getStream().print(t);
        SQLElement elem = this.getDir().getElement(t);
        if (elem == null) {
            this.getStream().println(" : no element");
            return;
        }
        this.getStream().println("... ");
        for (SQLElementLink elemLink : elem.getOwnedLinks().getByType(SQLElementLink.LinkType.COMPOSITION)) {
            final Path pathToForeign = elemLink.getPath().minusLast();
            final Step toPrivateStep = elemLink.getPath().getStep(-1);
            final SQLElement privateElement = elemLink.getOwned();
            SQLTable privateTable = privateElement.getTable();
            SQLSelect sel = new SQLSelect();
            sel.setArchivedPolicy(SQLSelect.ArchiveMode.BOTH);
            sel.addSelect(privateTable.getKey());
            assert (toPrivateStep.isForeign().booleanValue());
            sel.addJoin("INNER", null, toPrivateStep.reverse(), "m");
            String req = String.valueOf(sel.asString()) + " GROUP BY " + privateTable.getKey().getFieldRef() + " HAVING count(" + privateTable.getKey().getFieldRef() + ")>1";
            final List privateIDs = t.getDBSystemRoot().getDataSource().executeCol(req);
            if (privateIDs.size() <= 0) continue;
            this.getStream().println("\t" + elemLink + " fixing " + privateIDs.size() + " ... ");
            final SQLField archF = t.getArchiveField();
            final SQLField privateArchF = privateTable.getArchiveField();
            if (archF == null != (privateArchF == null)) {
                throw new IllegalStateException("Incoherent archive field : " + archF + " / " + privateArchF);
            }
            SQLUtils.executeAtomic(t.getDBSystemRoot().getDataSource(), new SQLUtils.SQLFactory<Object>(){

                @Override
                public Object create() throws SQLException {
                    for (final Number privateID : privateIDs) {
                        SQLRowValues vals = new SQLRowValues(t);
                        if (archF != null) {
                            vals.putNulls(archF.getName());
                        }
                        final SQLField ff = toPrivateStep.getSingleField();
                        vals.assurePath(pathToForeign).putNulls(ff.getName());
                        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(vals);
                        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                            @Override
                            public SQLSelect transformChecked(SQLSelect fixSel) {
                                fixSel.setArchivedPolicy(SQLSelect.ArchiveMode.BOTH);
                                fixSel.setWhere(new Where(fixSel.getAlias(ff), "=", (Object)privateID));
                                return fixSel;
                            }
                        });
                        List<SQLRowValues> tIDs = fetcher.fetch();
                        for (SQLRowValues tID : tIDs) {
                            SQLRowValues reallyPrivate = tID == tIDs.get(0) ? new SQLRowValues(privateElement.getTable()).setID(privateID) : privateElement.createCopy(privateID.intValue());
                            if (archF != null) {
                                reallyPrivate.put(privateArchF.getName(), tID.getObject(archF.getName()));
                            }
                            new SQLRowValues(pathToForeign.getLast()).setID(tID.followPath(pathToForeign).getIDNumber()).put(ff.getName(), (Object)reallyPrivate).update();
                        }
                    }
                    return null;
                }
            });
        }
        this.getStream().println(t + " done");
    }
}

