/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.map.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.map.model.Ville;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class VilleEditorPanel
extends JPanel
implements ActionListener {
    final JTextField textVille = new JTextField(20);
    final JTextField textCodePostal = new JTextField(8);
    final JButton buttonAdd = new JButton("Ajouter");
    final JButton buttonCancel = new JButton("Annuler");

    public VilleEditorPanel(String s) {
        if (s == null) {
            s = "";
        }
        s = s.trim();
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        c.anchor = 13;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Ville", 4), c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        c.anchor = 17;
        this.add((Component)this.textVille, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)new JLabel("Code postal", 4), c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 0;
        c.anchor = 17;
        this.add((Component)this.textCodePostal, c);
        c.gridx = 1;
        ++c.gridy;
        c.gridwidth = 1;
        c.anchor = 13;
        c.weightx = 1.0;
        this.add((Component)this.buttonAdd, c);
        c.gridwidth = 0;
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)this.buttonCancel, c);
        if (!s.isEmpty()) {
            if (Character.isDigit(s.charAt(0))) {
                int index = s.indexOf(32);
                if (index > 0) {
                    this.textCodePostal.setText(s.substring(0, index));
                    this.textVille.setText(s.substring(index).trim());
                } else {
                    this.textCodePostal.setText(s);
                }
            } else {
                this.textVille.setText(s);
            }
        }
        this.buttonAdd.addActionListener(this);
        this.buttonCancel.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Container c;
        if (e.getSource().equals(this.buttonAdd)) {
            String name = this.textVille.getText().trim();
            String code = this.textCodePostal.getText().trim();
            if (!name.isEmpty()) {
                Ville.addVille(new Ville(name, 0L, 0L, 0L, code));
            }
        }
        if ((c = SwingUtilities.getAncestorOfClass(Window.class, this)) != null) {
            ((Window)c).setVisible(false);
            ((Window)c).dispose();
        }
    }
}

