/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.map.ui;

import java.util.List;
import javax.swing.JOptionPane;
import org.openconcerto.map.model.Ville;
import org.openconcerto.ui.component.ITextComboCache;

public class ITextComboCacheVille
implements ITextComboCache {
    final List<String> villesNames = Ville.getVillesNames();

    public Ville createVilleFrom(String string) {
        string = string.trim();
        Ville v = null;
        int i1 = string.indexOf(40);
        int i2 = string.indexOf(41);
        if (i1 > 2 && i2 > i1 + 1) {
            String ville = string.substring(0, i1).trim();
            String cp = string.substring(i1 + 1, i2).trim();
            v = new Ville(ville, 0L, 0L, 0L, cp);
        }
        return v;
    }

    @Override
    public boolean isValid() {
        return this.villesNames.size() > 0;
    }

    @Override
    public void addToCache(String string) {
        Ville v = this.createVilleFrom(string);
        if (v != null) {
            Ville.addVille(v);
        } else {
            JOptionPane.showMessageDialog(null, "Format incorrect, la ville doit \u00eatre du format VILLE (CODEPOSTAL)\n Ex:  Abbeville (80100)");
        }
    }

    @Override
    public void deleteFromCache(String string) {
        Ville v = Ville.getVilleFromVilleEtCode(string);
        if (v != null) {
            Ville.removeVille(v);
        }
    }

    @Override
    public List<String> getCache() {
        if (this.villesNames.size() <= 0) {
            throw new IllegalArgumentException("Ville.parseFile() and Region.parseFile() never called");
        }
        return this.villesNames;
    }

    @Override
    public List<String> loadCache(boolean readCache) {
        return this.villesNames;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " with " + this.villesNames.size() + " cities";
    }
}

