/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.map.model;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.map.model.MapPoint;
import org.openconcerto.map.model.Ville;
import org.openconcerto.utils.StringUtils;

public class Region {
    private static final String DEPARTEMENTS_TXT = "departements.txt";
    private static final ArrayList<Region> regions = new ArrayList(100);
    private long minX;
    private long minY;
    private long maxX;
    private long maxY;
    private String name = "noname";
    private ArrayList<MapPoint> points = new ArrayList();
    private static boolean loaded = false;
    static Region currentRegion;

    public static synchronized void parseFile() {
        if (loaded) {
            throw new IllegalStateException("Data already loaded");
        }
        try {
            InputStreamReader fReader = new InputStreamReader(Region.class.getResourceAsStream(DEPARTEMENTS_TXT), "CP1252");
            BufferedReader bufReader = new BufferedReader(fReader, 0x100000);
            String line = bufReader.readLine();
            line = bufReader.readLine();
            int c = 0;
            while (line != null) {
                Region.parseLine(line);
                line = bufReader.readLine();
                ++c;
            }
            bufReader.close();
            fReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Region.removeBadRegions();
        loaded = true;
    }

    public static synchronized void saveFile() {
        int c = 0;
        try {
            FileWriter fW = new FileWriter(DEPARTEMENTS_TXT);
            PrintWriter pW = new PrintWriter(fW);
            for (Region region : regions) {
                System.out.println(region);
                pW.println(region.name);
                List<MapPoint> l = region.getPoints();
                int size = l.size();
                int i = 0;
                while (i < size) {
                    MapPoint element = l.get(i);
                    pW.println(String.valueOf(element.getX()) + " " + element.getY());
                    ++c;
                    ++i;
                }
            }
            fW.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Total points saved:" + c);
    }

    private static synchronized void removeBadRegions() {
        int i = regions.size() - 1;
        while (i >= 0) {
            Region r = regions.get(i);
            if (r.name.trim().equalsIgnoreCase("bad")) {
                regions.remove(i);
            }
            --i;
        }
    }

    private static void parseLine(String line) {
        List<String> strs = StringUtils.fastSplit(line, ' ');
        if (strs.size() == 2) {
            if (currentRegion == null) {
                currentRegion = new Region();
                regions.add(currentRegion);
            }
        } else {
            if (currentRegion != null && currentRegion.getPoints().size() > 0 && !regions.contains(currentRegion = new Region())) {
                regions.add(currentRegion);
            }
            if (currentRegion != null) {
                Region.currentRegion.name = line;
            }
            return;
        }
        MapPoint p = new MapPoint(Ville.parsePositiveLong(strs.get(0)), Ville.parsePositiveLong(strs.get(1)));
        currentRegion.addPoint(p);
    }

    private void addPoint(MapPoint p) {
        if (this.points.size() == 0) {
            this.maxX = p.getX();
            this.minX = p.getX();
            this.maxY = p.getY();
            this.minY = p.getY();
        }
        this.points.add(p);
        if (p.getX() < this.minX) {
            this.minX = p.getX();
        }
        if (p.getX() > this.maxX) {
            this.maxX = p.getX();
        }
        if (p.getY() < this.minY) {
            this.minY = p.getY();
        }
        if (p.getY() > this.maxY) {
            this.maxY = p.getY();
        }
    }

    public static synchronized List<Region> getRegions() {
        return regions;
    }

    public List<MapPoint> getPoints() {
        return this.points;
    }

    public static Region getCurrentRegion() {
        return currentRegion;
    }

    public static void setCurrentRegion(Region currentRegion) {
        Region.currentRegion = currentRegion;
    }

    public long getMaxX() {
        return this.maxX;
    }

    public long getMaxY() {
        return this.maxY;
    }

    public long getMinX() {
        return this.minX;
    }

    public long getMinY() {
        return this.minY;
    }

    public String toString() {
        return "Region :" + this.name + " size:" + this.getPoints().size();
    }

    public String getName() {
        return this.name;
    }
}

