/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils;

import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.erp.utils.StatusListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.changer.correct.FixSerial;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateRoot;
import org.openconcerto.utils.ExceptionHandler;

public class ActionDB {
    private static final Properties props = new Properties();

    static {
        props.put("jdbc.connection.allowMultiQueries", "true");
    }

    public static void dupliqueDB(String baseDefault, String newBase, StatusListener l) {
        DBSystemRoot sysRoot = Configuration.getInstance().getSystemRoot();
        try {
            ActionDB.log(l, "Cr\u00e9ation du sch\u00e9ma");
            if (!sysRoot.getChildrenNames().contains(baseDefault)) {
                sysRoot.addRootToMap(baseDefault);
                sysRoot.refetch(Collections.singleton(baseDefault));
            }
            DBRoot baseSQLDefault = sysRoot.getRoot(baseDefault);
            ActionDB.log(l, "Traitement des " + baseSQLDefault.getChildrenNames().size() + " tables");
            SQLCreateRoot createRoot = baseSQLDefault.getDefinitionSQL(sysRoot.getSyntax());
            SQLDataSource ds = sysRoot.getDataSource();
            List<String> sql = createRoot.asStringList(newBase, false, true, EnumSet.of(ChangeTable.ConcatStep.ADD_CONSTRAINT));
            ds.execute(sql.get(0));
            ds.execute(sql.get(1));
            sysRoot.addRootToMap(newBase);
            boolean origVal = Boolean.getBoolean("org.openconcerto.sql.noautoCreateMetadata");
            if (!origVal) {
                System.setProperty("org.openconcerto.sql.noautoCreateMetadata", "true");
            }
            sysRoot.refetch(Collections.singleton(newBase));
            if (!origVal) {
                System.setProperty("org.openconcerto.sql.noautoCreateMetadata", "false");
            }
            DBRoot baseSQLNew = sysRoot.getRoot(newBase);
            Set<SQLTable> newTables = baseSQLNew.getTables();
            int i = 0;
            for (SQLTable table : newTables) {
                String tableName = table.getName();
                ActionDB.log(l, "Copie de la table " + tableName + " " + (i + 1) + "/" + newTables.size());
                ActionDB.dumpTable(baseSQLDefault, table);
                ActionDB.log(l, "Table " + tableName + " " + (i + 1) + "/" + newTables.size() + " OK");
                ++i;
            }
            ds.execute(sql.get(2));
            assert (sql.size() == 3);
            if (sysRoot.getServer().getSQLSystem() == SQLSystem.POSTGRESQL) {
                ActionDB.log(l, "Maj des s\u00e9quences des tables");
                new FixSerial(sysRoot).changeAll(baseSQLNew);
            }
            ActionDB.log(l, "Duplication termin\u00e9e");
        }
        catch (Throwable e) {
            e.printStackTrace();
            ExceptionHandler.handle("Erreur pendant la cr\u00e9ation de la base!", e);
            ActionDB.log(l, "Erreur pendant la duplication");
        }
    }

    private static void log(StatusListener l, String message) {
        if (l != null) {
            l.statusChanged(message);
        }
    }

    private static void dumpTable(DBRoot source, SQLTable newTable) {
        try {
            SQLRowValues.insertFromTable(newTable, source.getTable(newTable.getName()));
        }
        catch (SQLException e) {
            System.err.println("Unable to dump table " + newTable.getName());
            e.printStackTrace();
        }
    }

    private static void updateMultiBase() {
        System.err.println("Start");
        ComptaPropsConfiguration instance = ComptaPropsConfiguration.create();
        Configuration.setInstance(instance);
        SQLBase base = Configuration.getInstance().getBase();
        SQLTable tableBase = base.getTable("SOCIETE_COMMON");
        SQLSelect sel = new SQLSelect(base, false);
        sel.addSelect(tableBase.getField("DATABASE_NAME"));
        List listBasesNX = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
        ActionDB.reOrderCompteID("Default");
        System.err.println("End");
    }

    private static void updateSaisieVC(String databaseName) {
        System.err.println("Update " + databaseName);
        String select = "SELECT MONTANT_TTC, TAUX, ID FROM \"" + databaseName + "\".SAISIE_VENTE_COMPTOIR, \"" + databaseName + "\".TAXE";
        System.err.println("Request " + select);
        List listBaseNX = (List)Configuration.getInstance().getBase().getDataSource().execute(select, new ArrayListHandler());
        int i = 0;
        while (i < listBaseNX.size()) {
            Object[] tmp = (Object[])listBaseNX.get(i);
            PrixTTC p = new PrixTTC(Long.parseLong(tmp[0].toString()));
            long ht = p.calculLongHT(((Float)tmp[1]).doubleValue() / 100.0);
            String updateVC = "UPDATE \"" + databaseName + "\".SAISIE_VENTE_COMPTOIR SET MONTANT_HT = " + ht + " WHERE ID=" + tmp[2];
            Configuration.getInstance().getBase().execute(updateVC);
            ++i;
        }
    }

    public static void setOrdreComptePCE(String databaseName) {
        String select = "SELECT ID, ORDRE FROM \"" + databaseName + "\".COMPTE_PCE ORDER BY NUMERO";
        List listBaseNX = (List)Configuration.getInstance().getBase().getDataSource().execute(select, new ArrayListHandler());
        int i = 0;
        while (i < listBaseNX.size()) {
            Object[] tmp = (Object[])listBaseNX.get(i);
            String update = "UPDATE \"" + databaseName + "\".COMPTE_PCE SET ORDRE=" + (i + 1) + " WHERE ID=" + tmp[0];
            Configuration.getInstance().getBase().execute(update);
            ++i;
        }
    }

    public static void reOrderCompteID(String databaseName) {
        String update;
        int id;
        Object[] tmp;
        String select = "SELECT ID, ORDRE FROM \"" + databaseName + "\".COMPTE_PCE WHERE ID > 1 ORDER BY NUMERO";
        List listBaseNX = (List)Configuration.getInstance().getBase().getDataSource().execute(select, new ArrayListHandler());
        int i = 0;
        while (i < listBaseNX.size()) {
            tmp = (Object[])listBaseNX.get(i);
            id = Integer.valueOf(tmp[0].toString());
            update = "UPDATE \"" + databaseName + "\".COMPTE_PCE SET ID=" + (id + 1000) + " WHERE ID=" + id;
            Configuration.getInstance().getBase().execute(update);
            ++i;
        }
        select = "SELECT ID, ORDRE FROM \"" + databaseName + "\".COMPTE_PCE WHERE ID > 1 ORDER BY NUMERO";
        listBaseNX = (List)Configuration.getInstance().getBase().getDataSource().execute(select, new ArrayListHandler());
        i = 0;
        while (i < listBaseNX.size()) {
            tmp = (Object[])listBaseNX.get(i);
            id = Integer.valueOf(tmp[0].toString());
            update = "UPDATE \"" + databaseName + "\".COMPTE_PCE SET ID=" + (i + 2) + " WHERE ID=" + id;
            Configuration.getInstance().getBase().execute(update);
            ++i;
        }
    }

    public static void setOrder(SQLBase base) {
        Set<String> tableNames = base.getTableNames();
        for (String tableName : tableNames) {
            SQLTable table = base.getTable(tableName);
            SQLField field = table.getOrderField();
            if (field == null) continue;
            base.execute("ALTER TABLE \"" + tableName + "\" ALTER COLUMN \"" + field.getName() + "\" SET DEFAULT 0;");
            base.execute("ALTER TABLE \"" + tableName + "\" ALTER COLUMN \"" + field.getName() + "\" SET NOT NULL;");
        }
    }

    public static void correct(SQLBase base) {
        Set<String> tableNames = base.getTableNames();
        for (String tableName : tableNames) {
            SQLTable t = base.getTable(tableName);
            SQLField orderF = t.getOrderField();
            if (orderF == null) continue;
            SQLSelect select = new SQLSelect(base);
            select.addSelect(orderF);
            List l = base.getDataSource().execute(select.asString());
            if (l != null && l.size() != 0) continue;
            SQLRowValues rowVals = new SQLRowValues(t);
            rowVals.put(orderF.getName(), 0);
            try {
                rowVals.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addUndefined(SQLBase base) {
        Set<String> tableNames = base.getTableNames();
        for (String tableName : tableNames) {
            SQLTable table = base.getTable(tableName);
            SQLField fieldPrimaryKey = table.getKey();
            if (fieldPrimaryKey == null || fieldPrimaryKey.getType().getJavaType().getSuperclass() == null || fieldPrimaryKey.getType().getJavaType().getSuperclass() != Number.class) continue;
            String patch = "INSERT INTO \"" + tableName + "\"(\"" + fieldPrimaryKey.getName() + "\") VALUES (1)";
            base.execute(patch);
        }
    }

    public static void main(String[] args) {
    }
}

