/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.panel.compta.AbstractExport;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.StringUtils;

public class ExportCielRImport
extends AbstractExport {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("##0.00", DecimalFormatSymbols.getInstance(Locale.UK));
    private List<Object[]> data;

    private static String formatCents(Number n) {
        return DECIMAL_FORMAT.format(BigDecimal.valueOf(n.longValue()).movePointLeft(2));
    }

    public ExportCielRImport(DBRoot rootSociete) {
        super(rootSociete, "Ciel RImport", ".txt");
    }

    @Override
    protected int fetchData(Date from, Date to, SQLRow selectedJournal, boolean onlyNew) {
        List l;
        SQLTable tableEcriture = this.getEcritureT();
        SQLTable tableMouvement = tableEcriture.getForeignTable("ID_MOUVEMENT");
        SQLTable tableCompte = tableEcriture.getForeignTable("ID_COMPTE_PCE");
        SQLTable tableJrnl = tableEcriture.getForeignTable("ID_JOURNAL");
        SQLSelect sel = this.createSelect(from, to, selectedJournal, onlyNew);
        sel.addSelect(tableJrnl.getField("CODE"));
        sel.addSelect(tableJrnl.getField("NOM"));
        sel.addSelect(tableEcriture.getField("DATE"));
        sel.addSelect(tableCompte.getField("NUMERO"));
        sel.addSelect(tableCompte.getField("NOM"));
        sel.addSelect(tableMouvement.getField("NUMERO"));
        sel.addSelect(tableEcriture.getField("NOM"));
        sel.addSelect(tableEcriture.getField("DEBIT"));
        sel.addSelect(tableEcriture.getField("CREDIT"));
        sel.addFieldOrder(tableJrnl.getField("CODE"));
        sel.addFieldOrder(tableEcriture.getField("DATE"));
        sel.addFieldOrder(tableMouvement.getField("NUMERO"));
        this.data = l = (List)this.getRootSociete().getDBSystemRoot().getDataSource().execute(sel.asString(), new ArrayListHandler());
        return l == null ? 0 : l.size();
    }

    @Override
    protected void export(OutputStream out) throws IOException {
        OutputStreamWriter bufOut = new OutputStreamWriter(out, StringUtils.Cp1252);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        for (Object[] objectArray : this.data) {
        }
    }
}

