/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.model;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.core.finance.payment.element.ChequeType;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.utils.ExceptionHandler;

public class GestionChequesModel {
    private SQLTable chqTable;
    private final IListe list;
    private final ChequeType chequeType;

    public GestionChequesModel(IListe list, ChequeType fields) {
        this.list = list;
        this.chqTable = list.getSource().getPrimaryTable();
        this.chequeType = fields;
    }

    public final ChequeType getChequeType() {
        return this.chequeType;
    }

    private final IListe getList() {
        return this.list;
    }

    public int getNbChequeSelected() {
        return this.getList().getSelection().getSelectedIDs().size();
    }

    public final void addSelectionListener(PropertyChangeListener l) {
        this.getList().getSelection().addPropertyChangeListener("selectedIDs", l);
    }

    public long getMontantTotalSelected() {
        long montant = 0L;
        for (SQLRowAccessor sQLRowAccessor : this.getList().getSelectedRows()) {
            Number amount = (Number)sQLRowAccessor.getObject("MONTANT");
            montant += amount == null ? 0L : amount.longValue();
        }
        return montant;
    }

    public void selectionDecaisseAll() {
        Date now = new Date();
        ITableModel model = this.getList().getModel();
        int rowCount = model.getRowCount();
        ArrayList<Integer> ids = new ArrayList<Integer>(rowCount / 2);
        int i = 0;
        while (i < rowCount) {
            ListSQLLine row = model.getRow(i);
            Calendar dateMin = row.getRow().getDate("DATE_MIN_DEPOT");
            if (dateMin != null && now.after(dateMin.getTime())) {
                ids.add(row.getID());
            }
            ++i;
        }
        this.getList().selectIDs(ids);
    }

    public void deselectionAll() {
        this.getList().selectIDs(Collections.emptyList());
    }

    public void valideDepot(Date d, boolean print) {
        this.valideDepot(null, d, print, null);
    }

    public void valideDepot(SQLRowAccessor banque, Date d, boolean print, String s) {
        String fieldSelect = this.chequeType.getDoneFieldName();
        HashMap<String, Comparable<Boolean>> m = new HashMap<String, Comparable<Boolean>>();
        m.put(fieldSelect, Boolean.TRUE);
        m.put(this.chequeType.getDateFieldName(), d);
        List<SQLRowValues> selection = this.getList().getSelectedRows();
        ArrayList<Integer> listeCheque = new ArrayList<Integer>();
        for (SQLRowAccessor sQLRowAccessor : selection) {
            SQLRowValues valChq = new SQLRowValues(this.chqTable, m);
            Number id = sQLRowAccessor.getIDNumber();
            if (sQLRowAccessor.getBoolean(fieldSelect).booleanValue()) continue;
            listeCheque.add(id.intValue());
            try {
                valChq.update(id.intValue());
                this.chequeType.handle(banque, sQLRowAccessor, d, s);
            }
            catch (Exception e) {
                System.err.println("Erreur pendant la mise \u00e0 jour dans la table " + valChq.getTable().getName());
                ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration des \u00e9critures du ch\u00e9ques + " + this.chqTable.getName() + " ID : " + id);
                e.printStackTrace();
            }
        }
        if (print) {
            this.print(false, d);
        }
    }

    public void printPreview() {
        this.print(true, new Date());
    }

    private void print(boolean preview, Date d) {
        String fieldSelect = this.chequeType.getDoneFieldName();
        List<SQLRowValues> selection = this.getList().getSelectedRows();
        ArrayList<Integer> listeCheque = new ArrayList<Integer>();
        for (SQLRowAccessor sQLRowAccessor : selection) {
            Number id = sQLRowAccessor.getIDNumber();
            if (sQLRowAccessor.getBoolean(fieldSelect).booleanValue()) continue;
            listeCheque.add(id.intValue());
        }
        this.chequeType.print(listeCheque, preview, d);
    }
}

